/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class MaterialTranslationMerger {
    public static void main(String[] args) throws IOException {
        Map frMap;
        Map enMap;
        File enFile = new File("translations_en.yml");
        File frFile = new File("translations_fr.yml");
        File outFile = new File("translations_fr_merged.yml");
        Yaml yaml = new Yaml();
        try (FileInputStream enIn = new FileInputStream(enFile);){
            enMap = (Map)yaml.load((InputStream)enIn);
        }
        try (FileInputStream frIn = new FileInputStream(frFile);){
            frMap = (Map)yaml.load((InputStream)frIn);
        }
        LinkedHashMap<String, String> frMapLower = new LinkedHashMap<String, String>();
        if (frMap != null) {
            for (Map.Entry entry : frMap.entrySet()) {
                frMapLower.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
            }
        }
        LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>();
        for (Map.Entry entry : enMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String frValue = (String)frMapLower.get(key.toLowerCase());
            if (frValue != null && !frValue.isEmpty()) {
                merged.put(key, frValue);
                continue;
            }
            merged.put(key, value);
        }
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(outFile));){
            for (Map.Entry entry : merged.entrySet()) {
                printWriter.println((String)entry.getKey() + ": \"" + ((String)entry.getValue()).replace("\"", "\\\"") + "\"");
            }
        }
        System.out.println("Fichier translations_fr_merged.yml g\u00e9n\u00e9r\u00e9 !");
    }
}

