/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.utils;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Optional;
import net.brcdev.shopgui.ShopGuiPlusApi;
import org.bukkit.inventory.ItemStack;

public class PriceFormatter {
    private final DynaShopPlugin plugin;

    public PriceFormatter(DynaShopPlugin plugin) {
        this.plugin = plugin;
    }

    public String formatPrice(double price) {
        try {
            DecimalFormat df;
            int maximumFractionDigits = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("numberFormat.maximumFractionDigits", 8);
            String decimalSeparator = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getString("numberFormat.decimalSeparator", ".");
            String groupingSeparator = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getString("numberFormat.groupingSeparator", ",");
            int minimumFractionDigits = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("numberFormat.minimumFractionDigits", 0);
            boolean hideFraction = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getBoolean("numberFormat.hideFraction", true);
            boolean isInteger = price == Math.floor(price) && !Double.isInfinite(price);
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator(decimalSeparator.charAt(0));
            symbols.setGroupingSeparator(groupingSeparator.charAt(0));
            if (hideFraction && isInteger) {
                df = new DecimalFormat("#,##0", symbols);
                df.setMinimumFractionDigits(0);
                df.setMaximumFractionDigits(0);
            } else {
                df = new DecimalFormat("#,##0.#", symbols);
                df.setMaximumFractionDigits(maximumFractionDigits);
                df.setMinimumFractionDigits(minimumFractionDigits);
            }
            df.setGroupingUsed(true);
            return df.format(price);
        }
        catch (Exception e) {
            return String.format("%.2f", price);
        }
    }

    public String formatStock(int stock) {
        try {
            String groupingSeparator = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getString("numberFormat.groupingSeparator", ",");
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setGroupingSeparator(groupingSeparator.charAt(0));
            DecimalFormat df = new DecimalFormat("#,##0", symbols);
            df.setGroupingUsed(true);
            return df.format(stock);
        }
        catch (Exception e) {
            return String.valueOf(stock);
        }
    }

    public String getPriceByType(String shopID, String itemID, String priceType) {
        boolean useRecipe = this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID).orElse(DynaShopType.NONE) == DynaShopType.RECIPE;
        ItemStack itemStack = null;
        if (useRecipe && (itemStack = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem()) == null) {
            return "N/A";
        }
        switch (priceType) {
            case "buy": {
                Optional<Double> buyPrice;
                if (useRecipe) {
                    ItemStack finalItem = itemStack;
                    double recipePrice = this.plugin.getCalculatedPriceCache().get(shopID + ":" + itemID + ":buyPrice", () -> this.plugin.getPriceRecipe().calculatePrice(shopID, itemID, finalItem, "buyPrice", new HashSet<String>()));
                    if (recipePrice >= 0.0) {
                        return this.formatPrice(recipePrice);
                    }
                }
                if ((buyPrice = this.plugin.getStorageManager().getBuyPrice(shopID, itemID)).isPresent()) {
                    return this.formatPrice(buyPrice.get());
                }
                Optional<Double> configBuyPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyPrice", Double.class);
                if (configBuyPrice.isPresent()) {
                    return this.formatPrice(configBuyPrice.get());
                }
                return "N/A";
            }
            case "sell": {
                Optional<Double> sellPrice;
                if (useRecipe) {
                    ItemStack finalItem = itemStack;
                    double recipePrice = this.plugin.getCalculatedPriceCache().get(shopID + ":" + itemID + ":sellPrice", () -> this.plugin.getPriceRecipe().calculatePrice(shopID, itemID, finalItem, "sellPrice", new HashSet<String>()));
                    if (recipePrice >= 0.0) {
                        return this.formatPrice(recipePrice);
                    }
                }
                if ((sellPrice = this.plugin.getStorageManager().getSellPrice(shopID, itemID)).isPresent()) {
                    return this.formatPrice(sellPrice.get());
                }
                Optional<Double> configSellPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellPrice", Double.class);
                if (configSellPrice.isPresent()) {
                    return this.formatPrice(configSellPrice.get());
                }
                return "N/A";
            }
            case "buy_min": {
                Optional<Double> configBuyMinPrice;
                if (useRecipe) {
                    ItemStack finalItem = itemStack;
                    double recipePrice = this.plugin.getCalculatedPriceCache().get(shopID + ":" + itemID + ":buyDynamic.min", () -> this.plugin.getPriceRecipe().calculatePrice(shopID, itemID, finalItem, "buyDynamic.min", new HashSet<String>()));
                    if (recipePrice >= 0.0) {
                        return this.formatPrice(recipePrice);
                    }
                }
                if ((configBuyMinPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyMinPrice", Double.class)).isPresent()) {
                    return this.formatPrice(configBuyMinPrice.get());
                }
                return "N/A";
            }
            case "sell_min": {
                Optional<Double> configSellMinPrice;
                if (useRecipe) {
                    ItemStack finalItem = itemStack;
                    double recipePrice = this.plugin.getCalculatedPriceCache().get(shopID + ":" + itemID + ":sellDynamic.min", () -> this.plugin.getPriceRecipe().calculatePrice(shopID, itemID, finalItem, "sellDynamic.min", new HashSet<String>()));
                    if (recipePrice >= 0.0) {
                        return this.formatPrice(recipePrice);
                    }
                }
                if ((configSellMinPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellMinPrice", Double.class)).isPresent()) {
                    return this.formatPrice(configSellMinPrice.get());
                }
                return "N/A";
            }
            case "buy_max": {
                Optional<Double> configBuyMaxPrice;
                if (useRecipe) {
                    ItemStack finalItem = itemStack;
                    double recipePrice = this.plugin.getCalculatedPriceCache().get(shopID + ":" + itemID + ":buyDynamic.max", () -> this.plugin.getPriceRecipe().calculatePrice(shopID, itemID, finalItem, "buyDynamic.max", new HashSet<String>()));
                    if (recipePrice >= 0.0) {
                        return this.formatPrice(recipePrice);
                    }
                }
                if ((configBuyMaxPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyMaxPrice", Double.class)).isPresent()) {
                    return this.formatPrice(configBuyMaxPrice.get());
                }
                return "N/A";
            }
            case "sell_max": {
                Optional<Double> configSellMaxPrice;
                if (useRecipe) {
                    ItemStack finalItem = itemStack;
                    double recipePrice = this.plugin.getCalculatedPriceCache().get(shopID + ":" + itemID + ":sellDynamic.max", () -> this.plugin.getPriceRecipe().calculatePrice(shopID, itemID, finalItem, "sellDynamic.max", new HashSet<String>()));
                    if (recipePrice >= 0.0) {
                        return this.formatPrice(recipePrice);
                    }
                }
                if ((configSellMaxPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellMaxPrice", Double.class)).isPresent()) {
                    return this.formatPrice(configSellMaxPrice.get());
                }
                return "N/A";
            }
        }
        return "N/A";
    }

    public String getStockByType(String shopID, String itemID, String stockType) {
        switch (stockType) {
            case "stock": {
                Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(shopID, itemID);
                if (stockOptional.isPresent()) {
                    return this.formatStock(stockOptional.get());
                }
                stockOptional = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.base", Integer.class);
                if (stockOptional.isPresent()) {
                    return this.formatStock(stockOptional.get());
                }
                return "N/A";
            }
            case "stock_min": {
                Optional<Integer> minStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.min", Integer.class);
                if (minStock.isPresent()) {
                    if (minStock.get() < 0) {
                        return "N/A";
                    }
                } else {
                    minStock = Optional.of(this.plugin.getDataConfig().getStockMin());
                }
                return String.valueOf(minStock.get());
            }
            case "stock_max": {
                Optional<Integer> maxStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.max", Integer.class);
                if (maxStock.isPresent()) {
                    if (maxStock.get() < 0) {
                        return "N/A";
                    }
                } else {
                    maxStock = Optional.of(this.plugin.getDataConfig().getStockMax());
                }
                return String.valueOf(maxStock.get());
            }
        }
        return "N/A";
    }
}

