/*
 * Decompiled with CFR 0.152.
 */
package computer.livingroom.paperesources;

import computer.livingroom.paperesources.PaperResourcesCommand;
import computer.livingroom.paperesources.PaperResourcesListener;
import computer.livingroom.paperesources.PaperResourcesManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import lombok.Generated;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PaperResources
extends JavaPlugin {
    private static PaperResources instance;
    private PaperResourcesManager resourcesManager;

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        instance.getDataFolder().mkdir();
        instance.saveDefaultConfig();
        if (this.getServer().getServerResourcePack() != null) {
            this.getLogger().warning("Attempting to override resource-pack in server.properties");
            try {
                File serverProperties = new File(Paths.get(this.getDataFolder().getParentFile().getCanonicalFile().getParentFile().toString() + File.separatorChar + "server.properties", new String[0]).toString());
                FileInputStream in = new FileInputStream(serverProperties);
                Properties properties = new Properties();
                properties.load(in);
                FileOutputStream out = new FileOutputStream(serverProperties);
                properties.setProperty("resource-pack", "");
                properties.store(out, null);
                in.close();
                out.close();
                this.getLogger().warning("Done! Please restart the server to ensure changes take affect!");
            }
            catch (IOException e) {
                this.getLogger().severe("Could not access server properties file!");
            }
        }
        this.resourcesManager = new PaperResourcesManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PaperResourcesListener(), (Plugin)this);
        new PaperResourcesCommand().registerCommand(this.getCommand("paperresources"));
    }

    @Generated
    public static PaperResources getInstance() {
        return instance;
    }

    @Generated
    public PaperResourcesManager getResourcesManager() {
        return this.resourcesManager;
    }

    public static class Config {
        public static String getPrompt() {
            return PaperResources.getInstance().getConfig().getString("custom-prompt", "");
        }

        public static boolean isRequired() {
            return PaperResources.getInstance().getConfig().getBoolean("require-resource-packs", false);
        }
    }
}

