/*
 * Decompiled with CFR 0.152.
 */
package computer.livingroom.paperesources;

import computer.livingroom.paperesources.PaperResources;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PaperResourcesManager {
    private ResourcePackRequest resourceRequest;
    private final File resourceFile = new File(PaperResources.getInstance().getDataFolder(), "resources.txt");
    private final Logger logger;

    public PaperResourcesManager(PaperResources instance) {
        this.logger = instance.getLogger();
        try {
            this.resourceFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.createRequest();
    }

    public void addResourcePack(String url, int index, boolean rebuild, boolean resendResources) {
        List<String> urls;
        try {
            urls = this.getURLStrings();
        }
        catch (IOException e) {
            this.logger.severe("Unable to open resource file");
            return;
        }
        urls.add(index, url);
        this.createRequest(urls);
        this.saveUrls(urls);
        if (rebuild) {
            this.createRequest(urls);
            if (resendResources && this.isRequestValid()) {
                Bukkit.getServer().sendResourcePacks(this.resourceRequest);
            }
        }
    }

    public boolean removeResourcePack(String url, boolean rebuild, boolean resendResources) {
        List<String> urls;
        try {
            urls = this.getURLStrings();
        }
        catch (IOException e) {
            this.logger.severe("Unable to open resource file");
            return false;
        }
        boolean rc = urls.remove(url);
        if (rebuild) {
            this.createRequest(urls);
            if (resendResources && this.isRequestValid()) {
                Bukkit.getServer().sendResourcePacks(this.resourceRequest);
            }
        }
        this.saveUrls(urls);
        return rc;
    }

    public List<String> getURLStrings() throws IOException {
        return Files.readAllLines(this.resourceFile.toPath());
    }

    private void saveUrls(List<String> urls) {
        try {
            Files.write(this.resourceFile.toPath(), urls, Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.severe("Unable to save resource file");
        }
    }

    public boolean isRequestValid() {
        return this.resourceRequest != null && !this.resourceRequest.packs().isEmpty();
    }

    public void sendRequestToPlayer(Player player) {
        if (this.isRequestValid()) {
            player.sendResourcePacks(this.resourceRequest);
        }
    }

    public void reloadResources(boolean sendNewResources) {
        this.createRequest();
        if (sendNewResources && this.isRequestValid()) {
            Bukkit.getServer().sendResourcePacks(this.resourceRequest);
        }
    }

    private void createRequest() {
        try {
            this.createRequest(this.getURLStrings());
        }
        catch (IOException e) {
            this.logger.severe("Unable to open resource file");
            this.resourceRequest = null;
        }
    }

    private void createRequest(List<String> packs) {
        ArrayList<ResourcePackInfo> resourcePacks = new ArrayList<ResourcePackInfo>();
        if (packs.isEmpty()) {
            this.resourceRequest = null;
            return;
        }
        for (String s : packs.reversed()) {
            ResourcePackInfo info;
            if (s.isBlank()) continue;
            this.logger.info("Loading pack: " + s + "...");
            try {
                info = (ResourcePackInfo)ResourcePackInfo.resourcePackInfo().uri(URI.create(s)).computeHashAndBuild().get();
            }
            catch (Exception e) {
                this.logger.severe("Failed to load pack: " + s);
                this.logger.severe("Skipping...");
                continue;
            }
            this.logger.info("Loaded!");
            resourcePacks.add(info);
        }
        ResourcePackRequest.Builder builder = ResourcePackRequest.resourcePackRequest().packs(resourcePacks).replace(true).required(PaperResources.Config.isRequired());
        String prompt = PaperResources.Config.getPrompt();
        if (!prompt.isBlank()) {
            builder.prompt((Component)Component.text((String)prompt));
        }
        this.resourceRequest = (ResourcePackRequest)builder.build();
    }
}

