/*
 * Decompiled with CFR 0.152.
 */
package computer.livingroom.paperesources.utils.brigadier;

import com.google.common.collect.ObjectArrays;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;

public class BrigadierExecutor
implements TabExecutor {
    protected final CommandDispatcher<CommandSender> commandDispatcher;

    public BrigadierExecutor(@NonNull Consumer<CommandDispatcher<CommandSender>> dispatcherConsumer) {
        if (dispatcherConsumer == null) {
            throw new NullPointerException("dispatcherConsumer is marked non-null but is null");
        }
        this.commandDispatcher = new CommandDispatcher();
        dispatcherConsumer.accept(this.commandDispatcher);
    }

    public void registerCommand(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public final boolean onCommand(@NonNull CommandSender sender, @NonNull Command command, @NonNull String alias, @NonNull String[] args) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        try {
            int result = this.commandDispatcher.execute(this.getCommandString(alias, args), (Object)sender);
            if (result <= 0) {
                BrigadierExecutor.sendUsageMessage(sender, this.commandDispatcher);
                return true;
            }
        }
        catch (CommandSyntaxException e) {
            if (e.getMessage() != null) {
                sender.sendMessage((Component)Component.text((String)e.getMessage(), (TextColor)NamedTextColor.RED));
            }
            BrigadierExecutor.sendUsageMessage(sender, this.commandDispatcher);
            return true;
        }
        return true;
    }

    @NonNull
    public final List<String> onTabComplete(@NonNull CommandSender sender, @NonNull Command command, @NonNull String alias, @NonNull String[] args) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        String commandString = this.getCommandString(alias, args);
        Suggestions suggestions = (Suggestions)this.commandDispatcher.getCompletionSuggestions(this.commandDispatcher.parse(commandString, (Object)sender)).join();
        return suggestions.getList().stream().map(Suggestion::getText).collect(Collectors.toList());
    }

    private static void sendUsageMessage(@NonNull CommandSender sender, @NonNull CommandDispatcher<CommandSender> commandDispatcher) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (commandDispatcher == null) {
            throw new NullPointerException("commandDispatcher is marked non-null but is null");
        }
        sender.sendMessage((Component)Component.text((String)"Usages:", (TextColor)NamedTextColor.RED));
        for (String s : commandDispatcher.getAllUsage((CommandNode)commandDispatcher.getRoot(), (Object)sender, true)) {
            sender.sendMessage((Component)((TextComponent.Builder)Component.text().append(Component.text((String)"/", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)s, (TextColor)NamedTextColor.RED)))).build());
        }
    }

    public final String getCommandString(String alias, String[] args) {
        return String.join((CharSequence)" ", (CharSequence[])ObjectArrays.concat((Object)alias, (Object[])args));
    }
}

