/*
 * Decompiled with CFR 0.152.
 */
package carpet.api.settings;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.utils.Translations;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;

public final class RuleHelper {
    private RuleHelper() {
    }

    public static boolean getBooleanValue(CarpetRule<?> rule) {
        if (rule.type() == Boolean.class) {
            return (Boolean)rule.value();
        }
        if (Number.class.isAssignableFrom(rule.type())) {
            return ((Number)rule.value()).doubleValue() > 0.0;
        }
        return false;
    }

    public static String toRuleString(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name().toLowerCase(Locale.ROOT);
        }
        return value.toString();
    }

    public static boolean isInDefaultValue(CarpetRule<?> rule) {
        return rule.defaultValue().equals(rule.value());
    }

    public static <T> void resetToDefault(CarpetRule<T> rule, CommandSourceStack source) {
        try {
            rule.set(source, rule.defaultValue());
        }
        catch (InvalidRuleValueException e) {
            throw new IllegalStateException("Rule couldn't be set to default value!", e);
        }
    }

    public static String translatedName(CarpetRule<?> rule) {
        String key = String.format("%s.rule.%s.name", rule.settingsManager().identifier(), rule.name());
        return Translations.hasTranslation(key) ? Translations.tr(key) + String.format(" (%s)", rule.name()) : rule.name();
    }

    public static String translatedDescription(CarpetRule<?> rule) {
        return Translations.tr(String.format("%s.rule.%s.desc", rule.settingsManager().identifier(), rule.name()));
    }

    public static String translatedCategory(String manager, String category) {
        return Translations.tr("%s.category.%s".formatted(manager, category), category);
    }
}

