/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.fakes.CoralFeatureInterface;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.CoralClawFeature;
import net.minecraft.world.level.levelgen.feature.CoralMushroomFeature;
import net.minecraft.world.level.levelgen.feature.CoralTreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;

public interface FertilizableCoral
extends BonemealableBlock {
    public boolean isEnabled();

    default public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return this.isEnabled() && (Boolean)state.getValue((Property)BaseCoralPlantTypeBlock.WATERLOGGED) != false && world.getFluidState(pos.above()).is(FluidTags.WATER);
    }

    default public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() < 0.15;
    }

    default public void performBonemeal(ServerLevel worldIn, RandomSource random, BlockPos pos, BlockState blockUnder) {
        BlockPos randomPos;
        Holder block;
        int variant = random.nextInt(3);
        CoralClawFeature coral = switch (variant) {
            case 0 -> new CoralClawFeature(NoneFeatureConfiguration.CODEC);
            case 1 -> new CoralTreeFeature(NoneFeatureConfiguration.CODEC);
            default -> new CoralMushroomFeature(NoneFeatureConfiguration.CODEC);
        };
        MapColor color = blockUnder.getMapColor((BlockGetter)worldIn, pos);
        BlockState properBlock = blockUnder;
        HolderSet.Named coralBlocks = (HolderSet.Named)worldIn.registryAccess().registryOrThrow(Registries.BLOCK).getTag(BlockTags.CORAL_BLOCKS).orElseThrow();
        Iterator iterator = coralBlocks.iterator();
        while (iterator.hasNext() && (properBlock = ((Block)(block = (Holder)iterator.next()).value()).defaultBlockState()).getMapColor((BlockGetter)worldIn, pos) != color) {
        }
        worldIn.setBlock(pos, Blocks.WATER.defaultBlockState(), 4);
        if (!((CoralFeatureInterface)coral).growSpecific((Level)worldIn, random, pos, properBlock)) {
            worldIn.setBlock(pos, blockUnder, 3);
        } else if (worldIn.random.nextInt(10) == 0 && coralBlocks.contains(worldIn.getBlockState(randomPos = pos.offset(worldIn.random.nextInt(16) - 8, worldIn.random.nextInt(8), worldIn.random.nextInt(16) - 8)).getBlockHolder())) {
            worldIn.setBlock(randomPos, Blocks.WET_SPONGE.defaultBlockState(), 3);
        }
    }
}

