/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetServer;
import carpet.fakes.IngredientInterface;
import carpet.fakes.RecipeManagerInterface;
import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public class HopperCounter {
    private static final Map<DyeColor, HopperCounter> COUNTERS;
    public static final TextColor WHITE;
    public final DyeColor color;
    private final String coloredName;
    private final Object2LongMap<Item> counter = new Object2LongLinkedOpenHashMap();
    private long startTick = -1L;
    private long startMillis;
    private static final Map<Item, Block> DEFAULTS;

    private HopperCounter(DyeColor color) {
        this.color = color;
        Object hexColor = Integer.toHexString(color.getTextColor());
        if (((String)hexColor).length() < 6) {
            hexColor = "0".repeat(6 - ((String)hexColor).length()) + (String)hexColor;
        }
        this.coloredName = "#" + (String)hexColor + " " + color.getName();
    }

    public void add(MinecraftServer server, ItemStack stack) {
        if (this.startTick < 0L) {
            this.startTick = server.overworld().getGameTime();
            this.startMillis = System.currentTimeMillis();
        }
        Item item = stack.getItem();
        this.counter.put((Object)item, this.counter.getLong((Object)item) + (long)stack.getCount());
    }

    public void reset(MinecraftServer server) {
        this.counter.clear();
        this.startTick = server.overworld().getGameTime();
        this.startMillis = System.currentTimeMillis();
    }

    public static void resetAll(MinecraftServer server, boolean fresh) {
        for (HopperCounter counter : COUNTERS.values()) {
            counter.reset(server);
            if (!fresh) continue;
            counter.startTick = -1L;
        }
    }

    public static List<Component> formatAll(MinecraftServer server, boolean realtime) {
        ArrayList<Component> text = new ArrayList<Component>();
        for (HopperCounter counter : COUNTERS.values()) {
            List<Component> temp = counter.format(server, realtime, false);
            if (temp.size() <= 1) continue;
            if (!text.isEmpty()) {
                text.add(Messenger.s(""));
            }
            text.addAll(temp);
        }
        if (text.isEmpty()) {
            text.add(Messenger.s("No items have been counted yet."));
        }
        return text;
    }

    public List<Component> format(MinecraftServer server, boolean realTime, boolean brief) {
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : server.overworld().getGameTime() - this.startTick, 1L);
        if (this.startTick < 0L || ticks == 0L) {
            if (brief) {
                return Collections.singletonList(Messenger.c("b" + this.coloredName, "w : ", "gi -, -/h, - min "));
            }
            return Collections.singletonList(Messenger.c(this.coloredName, "w  hasn't started counting yet"));
        }
        long total = this.getTotalItems();
        if (total == 0L) {
            if (brief) {
                return Collections.singletonList(Messenger.c("b" + this.coloredName, "w : ", "wb 0", "w , ", "wb 0", "w /h, ", String.format("wb %.1f ", (double)ticks / 1200.0), "w min"));
            }
            return Collections.singletonList(Messenger.c("w No items for ", this.coloredName, String.format("w  yet (%.2f min.%s)", (double)ticks / 1200.0, realTime ? " - real time" : ""), "nb  [X]", "^g reset", "!/counter " + this.color.getName() + " reset"));
        }
        if (brief) {
            return Collections.singletonList(Messenger.c("b" + this.coloredName, "w : ", "wb " + total, "w , ", "wb " + total * 72000L / ticks, "w /h, ", String.format("wb %.1f ", (double)ticks / 1200.0), "w min"));
        }
        ArrayList<Component> items = new ArrayList<Component>();
        items.add(Messenger.c("w Items for ", this.coloredName, "w  (", String.format("wb %.2f", (double)ticks * 1.0 / 1200.0), "w  min" + (realTime ? " - real time" : "") + "), ", "w total: ", "wb " + total, "w , (", String.format("wb %.1f", (double)total * 1.0 * 72000.0 / (double)ticks), "w /h):", "nb [X]", "^g reset", "!/counter " + String.valueOf(this.color) + " reset"));
        items.addAll(this.counter.object2LongEntrySet().stream().sorted((e, f) -> Long.compare(f.getLongValue(), e.getLongValue())).map(e -> {
            Item item = (Item)e.getKey();
            MutableComponent itemName = Component.translatable((String)item.getDescriptionId());
            Style itemStyle = itemName.getStyle();
            TextColor color = HopperCounter.guessColor(item, (RegistryAccess)server.registryAccess());
            itemName.setStyle(color != null ? itemStyle.withColor(color) : itemStyle.withItalic(Boolean.valueOf(true)));
            long count = e.getLongValue();
            return Messenger.c("g - ", itemName, "g : ", "wb " + count, "g , ", String.format("wb %.1f", (double)count * 72000.0 / (double)ticks), "w /h");
        }).collect(Collectors.toList()));
        return items;
    }

    public static int appropriateColor(int color) {
        if (color == 0) {
            return MapColor.SNOW.col;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (r < 70) {
            r = 70;
        }
        if (g < 70) {
            g = 70;
        }
        if (b < 70) {
            b = 70;
        }
        return (r << 16) + (g << 8) + b;
    }

    public static TextColor fromItem(Item item, RegistryAccess registryAccess) {
        if (DEFAULTS.containsKey(item)) {
            return TextColor.fromRgb((int)HopperCounter.appropriateColor(HopperCounter.DEFAULTS.get((Object)item).defaultMapColor().col));
        }
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            return TextColor.fromRgb((int)HopperCounter.appropriateColor(dye.getDyeColor().getMapColor().col));
        }
        Block block = null;
        Registry itemRegistry = registryAccess.registryOrThrow(Registries.ITEM);
        Registry blockRegistry = registryAccess.registryOrThrow(Registries.BLOCK);
        ResourceLocation id = itemRegistry.getKey((Object)item);
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        } else if (blockRegistry.getOptional(id).isPresent()) {
            block = (Block)blockRegistry.get(id);
        }
        if (block != null) {
            if (block instanceof AbstractBannerBlock) {
                return TextColor.fromRgb((int)HopperCounter.appropriateColor(((AbstractBannerBlock)block).getColor().getMapColor().col));
            }
            if (block instanceof BeaconBeamBlock) {
                return TextColor.fromRgb((int)HopperCounter.appropriateColor(((BeaconBeamBlock)block).getColor().getMapColor().col));
            }
            return TextColor.fromRgb((int)HopperCounter.appropriateColor(block.defaultMapColor().col));
        }
        return null;
    }

    public static TextColor guessColor(Item item, RegistryAccess registryAccess) {
        TextColor direct = HopperCounter.fromItem(item, registryAccess);
        if (direct != null) {
            return direct;
        }
        if (CarpetServer.minecraft_server == null) {
            return WHITE;
        }
        ResourceLocation id = registryAccess.registryOrThrow(Registries.ITEM).getKey((Object)item);
        for (RecipeType type : registryAccess.registryOrThrow(Registries.RECIPE_TYPE)) {
            for (Recipe<?> r : ((RecipeManagerInterface)CarpetServer.minecraft_server.getRecipeManager()).getAllMatching(type, id, registryAccess)) {
                for (Ingredient ingredient : r.getIngredients()) {
                    for (Collection<ItemStack> stacks : ((IngredientInterface)ingredient).getRecipeStacks()) {
                        for (ItemStack iStak : stacks) {
                            TextColor cand = HopperCounter.fromItem(iStak.getItem(), registryAccess);
                            if (cand == null) continue;
                            return cand;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static HopperCounter getCounter(DyeColor color) {
        return COUNTERS.get(color);
    }

    public static HopperCounter getCounter(String color) {
        try {
            DyeColor colorEnum = DyeColor.valueOf((String)color.toUpperCase(Locale.ROOT));
            return COUNTERS.get(colorEnum);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public long getTotalItems() {
        return this.counter.isEmpty() ? 0L : this.counter.values().longStream().sum();
    }

    static {
        WHITE = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE);
        EnumMap<DyeColor, HopperCounter> counterMap = new EnumMap<DyeColor, HopperCounter>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            counterMap.put(color, new HopperCounter(color));
        }
        COUNTERS = Collections.unmodifiableMap(counterMap);
        DEFAULTS = Map.ofEntries(Map.entry(Items.DANDELION, Blocks.YELLOW_WOOL), Map.entry(Items.POPPY, Blocks.RED_WOOL), Map.entry(Items.BLUE_ORCHID, Blocks.LIGHT_BLUE_WOOL), Map.entry(Items.ALLIUM, Blocks.MAGENTA_WOOL), Map.entry(Items.AZURE_BLUET, Blocks.SNOW_BLOCK), Map.entry(Items.RED_TULIP, Blocks.RED_WOOL), Map.entry(Items.ORANGE_TULIP, Blocks.ORANGE_WOOL), Map.entry(Items.WHITE_TULIP, Blocks.SNOW_BLOCK), Map.entry(Items.PINK_TULIP, Blocks.PINK_WOOL), Map.entry(Items.OXEYE_DAISY, Blocks.SNOW_BLOCK), Map.entry(Items.CORNFLOWER, Blocks.BLUE_WOOL), Map.entry(Items.WITHER_ROSE, Blocks.BLACK_WOOL), Map.entry(Items.LILY_OF_THE_VALLEY, Blocks.WHITE_WOOL), Map.entry(Items.BROWN_MUSHROOM, Blocks.BROWN_MUSHROOM_BLOCK), Map.entry(Items.RED_MUSHROOM, Blocks.RED_MUSHROOM_BLOCK), Map.entry(Items.STICK, Blocks.OAK_PLANKS), Map.entry(Items.GOLD_INGOT, Blocks.GOLD_BLOCK), Map.entry(Items.IRON_INGOT, Blocks.IRON_BLOCK), Map.entry(Items.DIAMOND, Blocks.DIAMOND_BLOCK), Map.entry(Items.NETHERITE_INGOT, Blocks.NETHERITE_BLOCK), Map.entry(Items.SUNFLOWER, Blocks.YELLOW_WOOL), Map.entry(Items.LILAC, Blocks.MAGENTA_WOOL), Map.entry(Items.ROSE_BUSH, Blocks.RED_WOOL), Map.entry(Items.PEONY, Blocks.PINK_WOOL), Map.entry(Items.CARROT, Blocks.ORANGE_WOOL), Map.entry(Items.APPLE, Blocks.RED_WOOL), Map.entry(Items.WHEAT, Blocks.HAY_BLOCK), Map.entry(Items.PORKCHOP, Blocks.PINK_WOOL), Map.entry(Items.RABBIT, Blocks.PINK_WOOL), Map.entry(Items.CHICKEN, Blocks.WHITE_TERRACOTTA), Map.entry(Items.BEEF, Blocks.NETHERRACK), Map.entry(Items.ENCHANTED_GOLDEN_APPLE, Blocks.GOLD_BLOCK), Map.entry(Items.COD, Blocks.WHITE_TERRACOTTA), Map.entry(Items.SALMON, Blocks.ACACIA_PLANKS), Map.entry(Items.ROTTEN_FLESH, Blocks.BROWN_WOOL), Map.entry(Items.PUFFERFISH, Blocks.YELLOW_TERRACOTTA), Map.entry(Items.TROPICAL_FISH, Blocks.ORANGE_WOOL), Map.entry(Items.POTATO, Blocks.WHITE_TERRACOTTA), Map.entry(Items.MUTTON, Blocks.RED_WOOL), Map.entry(Items.BEETROOT, Blocks.NETHERRACK), Map.entry(Items.MELON_SLICE, Blocks.MELON), Map.entry(Items.POISONOUS_POTATO, Blocks.SLIME_BLOCK), Map.entry(Items.SPIDER_EYE, Blocks.NETHERRACK), Map.entry(Items.GUNPOWDER, Blocks.GRAY_WOOL), Map.entry(Items.TURTLE_SCUTE, Blocks.LIME_WOOL), Map.entry(Items.ARMADILLO_SCUTE, Blocks.ANCIENT_DEBRIS), Map.entry(Items.FEATHER, Blocks.WHITE_WOOL), Map.entry(Items.FLINT, Blocks.BLACK_WOOL), Map.entry(Items.LEATHER, Blocks.SPRUCE_PLANKS), Map.entry(Items.GLOWSTONE_DUST, Blocks.GLOWSTONE), Map.entry(Items.PAPER, Blocks.WHITE_WOOL), Map.entry(Items.BRICK, Blocks.BRICKS), Map.entry(Items.INK_SAC, Blocks.BLACK_WOOL), Map.entry(Items.SNOWBALL, Blocks.SNOW_BLOCK), Map.entry(Items.WATER_BUCKET, Blocks.WATER), Map.entry(Items.LAVA_BUCKET, Blocks.LAVA), Map.entry(Items.MILK_BUCKET, Blocks.WHITE_WOOL), Map.entry(Items.CLAY_BALL, Blocks.CLAY), Map.entry(Items.COCOA_BEANS, Blocks.COCOA), Map.entry(Items.BONE, Blocks.BONE_BLOCK), Map.entry(Items.COD_BUCKET, Blocks.BROWN_TERRACOTTA), Map.entry(Items.PUFFERFISH_BUCKET, Blocks.YELLOW_TERRACOTTA), Map.entry(Items.SALMON_BUCKET, Blocks.PINK_TERRACOTTA), Map.entry(Items.TROPICAL_FISH_BUCKET, Blocks.ORANGE_TERRACOTTA), Map.entry(Items.SUGAR, Blocks.WHITE_WOOL), Map.entry(Items.BLAZE_POWDER, Blocks.GOLD_BLOCK), Map.entry(Items.ENDER_PEARL, Blocks.WARPED_PLANKS), Map.entry(Items.NETHER_STAR, Blocks.DIAMOND_BLOCK), Map.entry(Items.PRISMARINE_CRYSTALS, Blocks.SEA_LANTERN), Map.entry(Items.PRISMARINE_SHARD, Blocks.PRISMARINE), Map.entry(Items.RABBIT_HIDE, Blocks.OAK_PLANKS), Map.entry(Items.CHORUS_FRUIT, Blocks.PURPUR_BLOCK), Map.entry(Items.SHULKER_SHELL, Blocks.SHULKER_BOX), Map.entry(Items.NAUTILUS_SHELL, Blocks.BONE_BLOCK), Map.entry(Items.HEART_OF_THE_SEA, Blocks.CONDUIT), Map.entry(Items.HONEYCOMB, Blocks.HONEYCOMB_BLOCK), Map.entry(Items.NAME_TAG, Blocks.BONE_BLOCK), Map.entry(Items.TOTEM_OF_UNDYING, Blocks.YELLOW_TERRACOTTA), Map.entry(Items.TRIDENT, Blocks.PRISMARINE), Map.entry(Items.GHAST_TEAR, Blocks.WHITE_WOOL), Map.entry(Items.PHANTOM_MEMBRANE, Blocks.BONE_BLOCK), Map.entry(Items.EGG, Blocks.BONE_BLOCK), Map.entry(Items.COPPER_INGOT, Blocks.COPPER_BLOCK), Map.entry(Items.AMETHYST_SHARD, Blocks.AMETHYST_BLOCK));
    }
}

