/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.logging.LoggerRegistry;
import carpet.logging.logHelpers.TrajectoryLogHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Entity {
    private TrajectoryLogHelper logHelper;

    public AbstractArrowMixin(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;DDDLnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void addLogger(EntityType entityType, double x, double y, double z, Level level, ItemStack itemStack, ItemStack weapon, CallbackInfo ci) {
        if (LoggerRegistry.__projectiles && !level.isClientSide) {
            this.logHelper = new TrajectoryLogHelper("projectiles");
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickCheck(CallbackInfo ci) {
        if (LoggerRegistry.__projectiles && this.logHelper != null) {
            this.logHelper.onTick(this.getX(), this.getY(), this.getZ(), this.getDeltaMovement());
        }
    }

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="RETURN")})
    private void removeOnEntity(EntityHitResult entityHitResult, CallbackInfo ci) {
        if (LoggerRegistry.__projectiles && this.logHelper != null) {
            this.logHelper.onFinish();
            this.logHelper = null;
        }
    }

    @Inject(method={"onHitBlock(Lnet/minecraft/world/phys/BlockHitResult;)V"}, at={@At(value="RETURN")})
    private void removeOnBlock(BlockHitResult blockHitResult, CallbackInfo ci) {
        if (LoggerRegistry.__projectiles && this.logHelper != null) {
            this.logHelper.onFinish();
            this.logHelper = null;
        }
    }
}

