/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.ChunkTicketManagerInterface;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Iterator;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DistanceManager.class})
public abstract class DistanceManager_spawnChunksMixin
implements ChunkTicketManagerInterface {
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> tickets;

    @Shadow
    protected abstract void removeTicket(long var1, Ticket<?> var3);

    @Shadow
    public abstract <T> void addRegionTicket(TicketType<T> var1, ChunkPos var2, int var3, T var4);

    @Override
    public void changeSpawnChunks(ChunkPos chunkPos, int distance) {
        long pos = chunkPos.toLong();
        SortedArraySet set = (SortedArraySet)this.tickets.get(pos);
        Ticket existingTicket = null;
        if (set != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Ticket ticket = (Ticket)iter.next();
                if (ticket.getType() != TicketType.START) continue;
                existingTicket = ticket;
                iter.remove();
            }
            set.add(existingTicket);
        }
        if (existingTicket != null) {
            this.removeTicket(pos, existingTicket);
        }
        if (distance > 0) {
            this.addRegionTicket(TicketType.START, chunkPos, distance, Unit.INSTANCE);
        }
    }
}

