/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.EntityInterface;
import carpet.patches.EntityPlayerMPFake;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements EntityInterface {
    @Shadow
    public float yRot;
    @Shadow
    public float yRotO;
    @Shadow
    public Level level;

    @Shadow
    @Nullable
    public abstract LivingEntity getControllingPassenger();

    @Override
    public float getMainYaw(float partialTicks) {
        return partialTicks == 1.0f ? this.yRot : Mth.lerp((float)partialTicks, (float)this.yRotO, (float)this.yRot);
    }

    @Inject(method={"isControlledByLocalInstance()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isFakePlayer(CallbackInfoReturnable<Boolean> cir) {
        if (this.getControllingPassenger() instanceof EntityPlayerMPFake) {
            cir.setReturnValue((Object)(!this.level.isClientSide ? 1 : 0));
        }
    }
}

