/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.script.CarpetEventServer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class}, priority=990)
public abstract class Explosion_scarpetEventMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;
    @Shadow
    @Final
    private float radius;
    @Shadow
    @Final
    private boolean fire;
    @Shadow
    @Final
    private ObjectArrayList<BlockPos> toBlow;
    @Shadow
    @Final
    private Explosion.BlockInteraction blockInteraction;
    @Shadow
    @Final
    @Nullable
    private Entity source;
    private List<Entity> affectedEntities;

    @Shadow
    public abstract LivingEntity getIndirectSourceEntity();

    @Shadow
    public static float getSeenPercent(Vec3 source, Entity entity) {
        return 0.0f;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/Holder;)V"}, at={@At(value="RETURN")})
    private void onExplosionCreated(Level world, Entity entity, DamageSource damageSource, ExplosionDamageCalculator explosionBehavior, double x, double y, double z, float power, boolean createFire, Explosion.BlockInteraction destructionType, ParticleOptions particleOptions, ParticleOptions particleOptions2, Holder soundEvent, CallbackInfo ci) {
        if (CarpetEventServer.Event.EXPLOSION_OUTCOME.isNeeded() && !world.isClientSide()) {
            this.affectedEntities = new ArrayList<Entity>();
        }
    }

    @Redirect(method={"explode()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Explosion;getSeenPercent(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/Entity;)F"))
    private float onExplosion(Vec3 source, Entity entity) {
        if (this.affectedEntities != null) {
            this.affectedEntities.add(entity);
        }
        return Explosion_scarpetEventMixin.getSeenPercent(source, entity);
    }

    @Inject(method={"finalizeExplosion(Z)V"}, at={@At(value="HEAD")})
    private void onExplosion(boolean spawnParticles, CallbackInfo ci) {
        if (CarpetEventServer.Event.EXPLOSION_OUTCOME.isNeeded() && !this.level.isClientSide()) {
            CarpetEventServer.Event.EXPLOSION_OUTCOME.onExplosion((ServerLevel)this.level, this.source, this::getIndirectSourceEntity, this.x, this.y, this.z, this.radius, this.fire, (List<BlockPos>)this.toBlow, this.affectedEntities, this.blockInteraction);
        }
    }
}

