/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.logging.LoggerRegistry;
import carpet.logging.logHelpers.TrajectoryLogHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends Entity {
    private TrajectoryLogHelper logHelper;

    public FallingBlockEntityMixin(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void addLogger(EntityType<? extends Projectile> entityType_1, Level world_1, CallbackInfo ci) {
        if (LoggerRegistry.__fallingBlocks && !world_1.isClientSide) {
            this.logHelper = new TrajectoryLogHelper("fallingBlocks");
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickCheck(CallbackInfo ci) {
        if (LoggerRegistry.__fallingBlocks && this.logHelper != null) {
            this.logHelper.onTick(this.getX(), this.getY(), this.getZ(), this.getDeltaMovement());
        }
    }

    public void remove(Entity.RemovalReason arg) {
        super.remove(arg);
        if (LoggerRegistry.__fallingBlocks && this.logHelper != null) {
            this.logHelper.onFinish();
        }
    }
}

