/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.WorldChunkInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunk_movableBEMixin
extends ChunkAccess
implements WorldChunkInterface {
    @Shadow
    @Final
    Level level;

    public LevelChunk_movableBEMixin(ChunkPos pos, UpgradeData upgradeData, LevelHeightAccessor heightLimitView, Registry<Biome> biome, long inhabitedTime, @Nullable LevelChunkSection[] sectionArrayInitializer, @Nullable BlendingData blendingData) {
        super(pos, upgradeData, heightLimitView, biome, inhabitedTime, sectionArrayInitializer, blendingData);
    }

    @Shadow
    public abstract BlockEntity getBlockEntity(BlockPos var1, LevelChunk.EntityCreationType var2);

    @Shadow
    protected abstract <T extends BlockEntity> void updateBlockEntityTicker(T var1);

    @Shadow
    public abstract void addAndRegisterBlockEntity(BlockEntity var1);

    @Redirect(method={"setBlockState(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/level/chunk/LevelChunk;getBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk$EntityCreationType;)Lnet/minecraft/world/level/block/entity/BlockEntity;"))
    private BlockEntity ifGetBlockEntity(LevelChunk worldChunk, BlockPos blockPos_1, LevelChunk.EntityCreationType worldChunk$CreationType_1) {
        if (!CarpetSettings.movableBlockEntities) {
            return this.getBlockEntity(blockPos_1, LevelChunk.EntityCreationType.CHECK);
        }
        return this.level.getBlockEntity(blockPos_1);
    }

    @Override
    public BlockState setBlockStateWithBlockEntity(BlockPos blockPos_1, BlockState newBlockState, BlockEntity newBlockEntity, boolean boolean_1) {
        int x = blockPos_1.getX() & 0xF;
        int y = blockPos_1.getY();
        int z = blockPos_1.getZ() & 0xF;
        LevelChunkSection chunkSection = this.getSection(this.getSectionIndex(y));
        if (chunkSection.hasOnlyAir() && newBlockState.isAir()) {
            return null;
        }
        boolean boolean_2 = chunkSection.hasOnlyAir();
        BlockState oldBlockState = chunkSection.setBlockState(x, y & 0xF, z, newBlockState);
        if (oldBlockState == newBlockState) {
            return null;
        }
        Block newBlock = newBlockState.getBlock();
        Block oldBlock = oldBlockState.getBlock();
        ((Heightmap)this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING)).update(x, y, z, newBlockState);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES)).update(x, y, z, newBlockState);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.OCEAN_FLOOR)).update(x, y, z, newBlockState);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.WORLD_SURFACE)).update(x, y, z, newBlockState);
        boolean boolean_3 = chunkSection.hasOnlyAir();
        if (boolean_2 != boolean_3) {
            this.level.getChunkSource().getLightEngine().updateSectionStatus(blockPos_1, boolean_3);
        }
        if (!this.level.isClientSide) {
            if (!(oldBlock instanceof MovingPistonBlock)) {
                oldBlockState.onRemove(this.level, blockPos_1, newBlockState, boolean_1);
            }
        } else if (oldBlock != newBlock && oldBlock instanceof EntityBlock) {
            this.level.removeBlockEntity(blockPos_1);
        }
        if (chunkSection.getBlockState(x, y & 0xF, z).getBlock() != newBlock) {
            return null;
        }
        BlockEntity oldBlockEntity = null;
        if (oldBlockState.hasBlockEntity() && (oldBlockEntity = this.getBlockEntity(blockPos_1, LevelChunk.EntityCreationType.CHECK)) != null) {
            oldBlockEntity.setBlockState(oldBlockState);
            this.updateBlockEntityTicker(oldBlockEntity);
        }
        if (oldBlockState.hasBlockEntity()) {
            if (newBlockEntity == null) {
                newBlockEntity = ((EntityBlock)newBlock).newBlockEntity(blockPos_1, newBlockState);
            }
            if (newBlockEntity != oldBlockEntity && newBlockEntity != null) {
                newBlockEntity.clearRemoved();
                this.level.setBlockEntity(newBlockEntity);
                newBlockEntity.setBlockState(newBlockState);
                this.updateBlockEntityTicker(newBlockEntity);
            }
        }
        if (!this.level.isClientSide) {
            newBlockState.onPlace(this.level, blockPos_1, oldBlockState, boolean_1);
        }
        this.unsaved = true;
        return oldBlockState;
    }
}

