/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntity_creativeFlyMixin
extends Entity {
    @Shadow
    protected abstract float getFlyingSpeed();

    public LivingEntity_creativeFlyMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @ModifyConstant(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, constant={@Constant(floatValue=0.91f)}, expect=2)
    private float drag(float original) {
        if (CarpetSettings.creativeFlyDrag != 0.09 && this instanceof Player) {
            Player self = (Player)this;
            if (self.getAbilities().flying && !this.onGround()) {
                return (float)(1.0 - CarpetSettings.creativeFlyDrag);
            }
        }
        return original;
    }

    @Inject(method={"getFrictionInfluencedSpeed(F)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void flyingAltSpeed(float slipperiness, CallbackInfoReturnable<Float> cir) {
        if (CarpetSettings.creativeFlySpeed != 1.0 && this instanceof Player) {
            Player self = (Player)this;
            if (self.getAbilities().flying && !this.onGround()) {
                cir.setReturnValue((Object)Float.valueOf(this.getFlyingSpeed() * (float)CarpetSettings.creativeFlySpeed));
            }
        }
    }

    @Inject(method={"canUsePortal(Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canChangeDimensions(CallbackInfoReturnable<Boolean> cir) {
        if (CarpetSettings.isCreativeFlying(this)) {
            cir.setReturnValue((Object)false);
        }
    }
}

