/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.EntityInterface;
import carpet.fakes.LivingEntityInterface;
import carpet.script.CarpetEventServer;
import carpet.script.EntityEventsGroup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntity_scarpetEventsMixin
extends Entity
implements LivingEntityInterface {
    @Shadow
    protected boolean jumping;

    @Shadow
    protected abstract void jumpFromGround();

    public LivingEntity_scarpetEventsMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F", shift=At.Shift.BEFORE)})
    private void entityTakingDamage(DamageSource source, float amount, CallbackInfo ci) {
        ((EntityInterface)((Object)this)).getEventContainer().onEvent(EntityEventsGroup.Event.ON_DAMAGE, Float.valueOf(amount), source);
        if (source.getEntity() instanceof ServerPlayer && CarpetEventServer.Event.PLAYER_DEALS_DAMAGE.isNeeded() && CarpetEventServer.Event.PLAYER_DEALS_DAMAGE.onDamage(this, amount, source)) {
            ci.cancel();
        }
    }

    @Override
    public void doJumpCM() {
        this.jumpFromGround();
    }

    @Override
    public boolean isJumpingCM() {
        return this.jumping;
    }
}

