/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.MinecraftServerInterface;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptServer;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServer_scarpetMixin
extends ReentrantBlockableEventLoop<TickTask>
implements MinecraftServerInterface {
    private CarpetScriptServer scriptServer;
    @Shadow
    @Final
    protected LevelStorageSource.LevelStorageAccess storageSource;
    @Shadow
    @Final
    private Map<ResourceKey<Level>, ServerLevel> levels;
    @Shadow
    private MinecraftServer.ReloadableResources resources;
    @Shadow
    @Final
    private ServerFunctionManager functionManager;
    @Shadow
    @Final
    private StructureTemplateManager structureTemplateManager;
    @Shadow
    private long nextTickTimeNanos;
    @Shadow
    private long lastOverloadWarningNanos;

    public MinecraftServer_scarpetMixin(String string_1) {
        super(string_1);
    }

    @Shadow
    protected abstract void tickServer(BooleanSupplier var1);

    @Shadow
    public abstract RegistryAccess.Frozen registryAccess();

    @Shadow
    public abstract PlayerList getPlayerList();

    @Shadow
    public abstract ServerTickRateManager tickRateManager();

    @Override
    public void forceTick(BooleanSupplier isAhead) {
        this.nextTickTimeNanos = this.lastOverloadWarningNanos = Util.getNanos();
        this.tickServer(isAhead);
        this.pollTask();
        while (this.pollTask()) {
            Thread.yield();
        }
    }

    @Override
    public LevelStorageSource.LevelStorageAccess getCMSession() {
        return this.storageSource;
    }

    @Override
    public Map<ResourceKey<Level>, ServerLevel> getCMWorlds() {
        return this.levels;
    }

    @Inject(method={"tickServer(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="CONSTANT", args={"stringValue=tallying"})})
    public void tickTasks(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        if (!this.tickRateManager().runsNormally()) {
            return;
        }
        CarpetEventServer.Event.TICK.onTick((MinecraftServer)this);
        CarpetEventServer.Event.NETHER_TICK.onTick((MinecraftServer)this);
        CarpetEventServer.Event.ENDER_TICK.onTick((MinecraftServer)this);
    }

    @Override
    public void reloadAfterReload(RegistryAccess newRegs) {
        this.resources.managers().updateRegistryTags();
        this.getPlayerList().saveAll();
        this.getPlayerList().reloadResources();
        this.functionManager.replaceLibrary(this.resources.managers().getFunctionLibrary());
        this.structureTemplateManager.onResourceManagerReload((ResourceManager)this.resources.resourceManager());
    }

    @Override
    public MinecraftServer.ReloadableResources getResourceManager() {
        return this.resources;
    }

    @Override
    public void addScriptServer(CarpetScriptServer scriptServer) {
        this.scriptServer = scriptServer;
    }

    @Override
    public CarpetScriptServer getScriptServer() {
        return this.scriptServer;
    }
}

