/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.BlockPistonBehaviourInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PistonStructureResolver.class})
public class PistonStructureResolver_customStickyMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private Direction pushDirection;
    @Unique
    private BlockPos pos_addBlockLine;
    @Unique
    private BlockPos behindPos_addBlockLine;
    @Unique
    private Direction dir_addBranchingBlocks;
    @Unique
    private BlockPos neighborPos_addBranchingBlocks;

    @Inject(method={"addBlockLine(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;")})
    private void captureBlockLinePositions(BlockPos originPos, Direction direction, CallbackInfoReturnable<Boolean> cir, BlockState blockstate, int i, BlockState oldState, BlockPos behindPos) {
        this.pos_addBlockLine = behindPos.relative(this.pushDirection);
        this.behindPos_addBlockLine = behindPos;
    }

    @Redirect(method={"addBlockLine(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canStickTo(Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private boolean onAddBlockLineCanStickToEachOther(BlockState state, BlockState behindState) {
        Block block = state.getBlock();
        if (block instanceof BlockPistonBehaviourInterface) {
            BlockPistonBehaviourInterface behaviourInterface = (BlockPistonBehaviourInterface)block;
            return behaviourInterface.isStickyToNeighbor(this.level, this.pos_addBlockLine, state, this.behindPos_addBlockLine, behindState, this.pushDirection.getOpposite(), this.pushDirection);
        }
        return state.canStickTo(behindState);
    }

    @Inject(method={"addBranchingBlocks(Lnet/minecraft/core/BlockPos;)Z"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;")})
    private void captureNeighborPositions(BlockPos pos, CallbackInfoReturnable<Boolean> cir, BlockState state, Direction[] dirs, int i, int j, Direction dir, BlockPos neighborPos) {
        this.dir_addBranchingBlocks = dir;
        this.neighborPos_addBranchingBlocks = neighborPos;
    }

    @Redirect(method={"addBranchingBlocks(Lnet/minecraft/core/BlockPos;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canStickTo(Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private boolean onAddBranchingBlocksCanStickToEachOther(BlockState neighborState, BlockState state, BlockPos pos) {
        Block block = state.getBlock();
        if (block instanceof BlockPistonBehaviourInterface) {
            BlockPistonBehaviourInterface behaviourInterface = (BlockPistonBehaviourInterface)block;
            return behaviourInterface.isStickyToNeighbor(this.level, pos, state, this.neighborPos_addBranchingBlocks, neighborState, this.dir_addBranchingBlocks, this.pushDirection);
        }
        return neighborState.canStickTo(state);
    }
}

