/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImpl_antiCheatDisabledMixin
extends ServerCommonPacketListenerImpl {
    @Shadow
    private int aboveGroundTickCount;
    @Shadow
    private int aboveGroundVehicleTickCount;

    public ServerGamePacketListenerImpl_antiCheatDisabledMixin(MinecraftServer minecraftServer, Connection connection, CommonListenerCookie cci) {
        super(minecraftServer, connection, cci);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void restrictFloatingBits(CallbackInfo ci) {
        if (CarpetSettings.antiCheatDisabled) {
            if (this.aboveGroundTickCount > 70) {
                --this.aboveGroundTickCount;
            }
            if (this.aboveGroundVehicleTickCount > 70) {
                --this.aboveGroundVehicleTickCount;
            }
        }
    }

    @Redirect(method={"handleMoveVehicle(Lnet/minecraft/network/protocol/game/ServerboundMoveVehiclePacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z"))
    private boolean isServerTrusting(ServerGamePacketListenerImpl serverPlayNetworkHandler) {
        return this.isSingleplayerOwner() || CarpetSettings.antiCheatDisabled;
    }

    @Redirect(method={"handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension()Z"))
    private boolean relaxMoveRestrictions(ServerPlayer serverPlayerEntity) {
        return CarpetSettings.antiCheatDisabled || serverPlayerEntity.isChangingDimension();
    }
}

