/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.script.CarpetEventServer;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class ServerGamePacketListenerImpl_scarpetEventsMixin {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handlePlayerInput(Lnet/minecraft/network/protocol/game/ServerboundPlayerInputPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setPlayerInput(FFZZ)V")})
    private void checkMoves(ServerboundPlayerInputPacket p, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_RIDES.isNeeded() && (p.getXxa() != 0.0f || p.getZza() != 0.0f || p.isJumping() || p.isShiftKeyDown())) {
            CarpetEventServer.Event.PLAYER_RIDES.onMountControls(this.player, p.getXxa(), p.getZza(), p.isJumping(), p.isShiftKeyDown());
        }
    }

    @Inject(method={"handlePlayerAction(Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;drop(Z)Z", ordinal=0, shift=At.Shift.BEFORE)})
    private void onQItem(ServerboundPlayerActionPacket playerActionC2SPacket_1, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_DROPS_ITEM.onPlayerEvent(this.player)) {
            ci.cancel();
        }
    }

    @Inject(method={"handlePlayerAction(Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;drop(Z)Z", ordinal=1, shift=At.Shift.BEFORE)})
    private void onCtrlQItem(ServerboundPlayerActionPacket playerActionC2SPacket_1, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_DROPS_STACK.onPlayerEvent(this.player)) {
            ci.cancel();
        }
    }

    @Inject(method={"handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;jumpFromGround()V")})
    private void onJump(ServerboundMovePlayerPacket playerMoveC2SPacket_1, CallbackInfo ci) {
        CarpetEventServer.Event.PLAYER_JUMPS.onPlayerEvent(this.player);
    }

    @Inject(method={"handlePlayerAction(Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;handleBlockBreakAction(Lnet/minecraft/core/BlockPos;Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket$Action;Lnet/minecraft/core/Direction;II)V", shift=At.Shift.BEFORE)})
    private void onClicked(ServerboundPlayerActionPacket packet, CallbackInfo ci) {
        if (packet.getAction() == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK && CarpetEventServer.Event.PLAYER_CLICKS_BLOCK.onBlockAction(this.player, packet.getPos(), packet.getDirection())) {
            ci.cancel();
        }
    }

    @Redirect(method={"handlePlayerAction(Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;releaseUsingItem()V"))
    private void onStopUsing(ServerPlayer serverPlayerEntity) {
        if (CarpetEventServer.Event.PLAYER_RELEASED_ITEM.isNeeded()) {
            InteractionHand hand = serverPlayerEntity.getUsedItemHand();
            ItemStack stack = serverPlayerEntity.getUseItem().copy();
            serverPlayerEntity.releaseUsingItem();
            CarpetEventServer.Event.PLAYER_RELEASED_ITEM.onItemAction(this.player, hand, stack);
        } else {
            serverPlayerEntity.releaseUsingItem();
        }
    }

    @Inject(method={"handleUseItemOn(Lnet/minecraft/network/protocol/game/ServerboundUseItemOnPacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;useItemOn(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;")})
    private void onBlockInteracted(ServerboundUseItemOnPacket playerInteractBlockC2SPacket_1, CallbackInfo ci) {
        BlockHitResult hitRes;
        InteractionHand hand;
        if (CarpetEventServer.Event.PLAYER_RIGHT_CLICKS_BLOCK.isNeeded() && CarpetEventServer.Event.PLAYER_RIGHT_CLICKS_BLOCK.onBlockHit(this.player, hand = playerInteractBlockC2SPacket_1.getHand(), hitRes = playerInteractBlockC2SPacket_1.getHitResult())) {
            ci.cancel();
        }
    }

    @Inject(method={"handleUseItem(Lnet/minecraft/network/protocol/game/ServerboundUseItemPacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetLastActionTime()V")})
    private void onItemClicked(ServerboundUseItemPacket playerInteractItemC2SPacket_1, CallbackInfo ci) {
        InteractionHand hand;
        if (CarpetEventServer.Event.PLAYER_USES_ITEM.isNeeded() && CarpetEventServer.Event.PLAYER_USES_ITEM.onItemAction(this.player, hand = playerInteractItemC2SPacket_1.getHand(), this.player.getItemInHand(hand).copy())) {
            ci.cancel();
        }
    }

    @Inject(method={"handlePlayerCommand(Lnet/minecraft/network/protocol/game/ServerboundPlayerCommandPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setShiftKeyDown(Z)V", ordinal=0)})
    private void onStartSneaking(ServerboundPlayerCommandPacket clientCommandC2SPacket_1, CallbackInfo ci) {
        CarpetEventServer.Event.PLAYER_STARTS_SNEAKING.onPlayerEvent(this.player);
    }

    @Inject(method={"handlePlayerCommand(Lnet/minecraft/network/protocol/game/ServerboundPlayerCommandPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setShiftKeyDown(Z)V", ordinal=1)})
    private void onStopSneaking(ServerboundPlayerCommandPacket clientCommandC2SPacket_1, CallbackInfo ci) {
        CarpetEventServer.Event.PLAYER_STOPS_SNEAKING.onPlayerEvent(this.player);
    }

    @Inject(method={"handlePlayerCommand(Lnet/minecraft/network/protocol/game/ServerboundPlayerCommandPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setSprinting(Z)V", ordinal=0)})
    private void onStartSprinting(ServerboundPlayerCommandPacket clientCommandC2SPacket_1, CallbackInfo ci) {
        CarpetEventServer.Event.PLAYER_STARTS_SPRINTING.onPlayerEvent(this.player);
    }

    @Inject(method={"handlePlayerCommand(Lnet/minecraft/network/protocol/game/ServerboundPlayerCommandPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setSprinting(Z)V", ordinal=1)})
    private void onStopSprinting(ServerboundPlayerCommandPacket clientCommandC2SPacket_1, CallbackInfo ci) {
        CarpetEventServer.Event.PLAYER_STOPS_SPRINTING.onPlayerEvent(this.player);
    }

    @Inject(method={"handlePlayerCommand(Lnet/minecraft/network/protocol/game/ServerboundPlayerCommandPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isSleeping()Z", shift=At.Shift.BEFORE)})
    private void onWakeUp(ServerboundPlayerCommandPacket clientCommandC2SPacket_1, CallbackInfo ci) {
        if (this.player.isSleeping()) {
            CarpetEventServer.Event.PLAYER_WAKES_UP.onPlayerEvent(this.player);
        } else {
            CarpetEventServer.Event.PLAYER_ESCAPES_SLEEP.onPlayerEvent(this.player);
        }
    }

    @Inject(method={"handlePlayerCommand(Lnet/minecraft/network/protocol/game/ServerboundPlayerCommandPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;tryToStartFallFlying()Z", shift=At.Shift.BEFORE)})
    private void onElytraEngage(ServerboundPlayerCommandPacket clientCommandC2SPacket_1, CallbackInfo ci) {
        CarpetEventServer.Event.PLAYER_DEPLOYS_ELYTRA.onPlayerEvent(this.player);
    }

    @Inject(method={"handleContainerButtonClick(Lnet/minecraft/network/protocol/game/ServerboundContainerButtonClickPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetLastActionTime()V")})
    private void onItemBeingPickedFromInventory(ServerboundContainerButtonClickPacket packet, CallbackInfo ci) {
    }

    @Inject(method={"handlePlaceRecipe(Lnet/minecraft/network/protocol/game/ServerboundPlaceRecipePacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetLastActionTime()V")})
    private void onRecipeSelectedInRecipeManager(ServerboundPlaceRecipePacket packet, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_CHOOSES_RECIPE.isNeeded() && CarpetEventServer.Event.PLAYER_CHOOSES_RECIPE.onRecipeSelected(this.player, packet.getRecipe(), packet.isShiftDown())) {
            ci.cancel();
        }
    }

    @Inject(method={"handleSetCarriedItem(Lnet/minecraft/network/protocol/game/ServerboundSetCarriedItemPacket;)V"}, at={@At(value="HEAD")})
    private void onUpdatedSelectedSLot(ServerboundSetCarriedItemPacket packet, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_SWITCHES_SLOT.isNeeded() && this.player.getServer() != null && this.player.getServer().isSameThread()) {
            CarpetEventServer.Event.PLAYER_SWITCHES_SLOT.onSlotSwitch(this.player, this.player.getInventory().selected, packet.getSlot());
        }
    }

    @Inject(method={"handleAnimate(Lnet/minecraft/network/protocol/game/ServerboundSwingPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetLastActionTime()V", shift=At.Shift.BEFORE)})
    private void onSwing(ServerboundSwingPacket packet, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_SWINGS_HAND.isNeeded() && !this.player.swinging) {
            CarpetEventServer.Event.PLAYER_SWINGS_HAND.onHandAction(this.player, packet.getHand());
        }
    }

    @Inject(method={"handleChatCommand(Lnet/minecraft/network/protocol/game/ServerboundChatCommandPacket;)V"}, at={@At(value="HEAD")})
    private void onChatCommandMessage(ServerboundChatCommandPacket serverboundChatCommandPacket, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_COMMAND.isNeeded()) {
            CarpetEventServer.Event.PLAYER_COMMAND.onPlayerMessage(this.player, serverboundChatCommandPacket.command());
        }
    }
}

