/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.ServerWorldInterface;
import carpet.script.CarpetEventServer;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevel_scarpetMixin
extends Level
implements ServerWorldInterface {
    @Final
    @Shadow
    private ServerLevelData serverLevelData;
    @Shadow
    @Final
    private PersistentEntitySectionManager<Entity> entityManager;

    protected ServerLevel_scarpetMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Inject(method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", shift=At.Shift.BEFORE, ordinal=1)})
    private void onNaturalLightinig(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci, @Local BlockPos blockPos, @Local(ordinal=1) boolean bl2) {
        if (CarpetEventServer.Event.LIGHTNING.isNeeded()) {
            CarpetEventServer.Event.LIGHTNING.onWorldEventFlag((ServerLevel)this, blockPos, bl2 ? 1 : 0);
        }
    }

    private Explosion.BlockInteraction getCMDestroyType(GameRules.Key<GameRules.BooleanValue> rule) {
        return this.getGameRules().getBoolean(rule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    @Inject(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/Holder;)Lnet/minecraft/world/level/Explosion;"}, at={@At(value="HEAD")})
    private void handleExplosion(Entity entity, DamageSource damageSource, ExplosionDamageCalculator explosionBehavior, double d, double e, double f, float g, boolean bl, Level.ExplosionInteraction explosionInteraction, ParticleOptions particleOptions, ParticleOptions particleOptions2, Holder<SoundEvent> soundEvent, CallbackInfoReturnable<Explosion> cir) {
        if (CarpetEventServer.Event.EXPLOSION.isNeeded()) {
            Explosion.BlockInteraction var10000 = switch (explosionInteraction) {
                case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
                case Level.ExplosionInteraction.BLOCK -> this.getCMDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
                case Level.ExplosionInteraction.MOB -> {
                    if (this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                        yield this.getCMDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                    }
                    yield Explosion.BlockInteraction.KEEP;
                }
                case Level.ExplosionInteraction.TNT -> this.getCMDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
                default -> throw new IncompatibleClassChangeError();
            };
            CarpetEventServer.Event.EXPLOSION.onExplosion((ServerLevel)this, entity, null, d, e, f, g, bl, null, null, var10000);
        }
    }

    @Inject(method={"unload(Lnet/minecraft/world/level/chunk/LevelChunk;)V"}, at={@At(value="HEAD")})
    private void handleChunkUnload(LevelChunk levelChunk, CallbackInfo ci) {
        if (CarpetEventServer.Event.CHUNK_UNLOADED.isNeeded()) {
            ServerLevel level = (ServerLevel)this;
            CarpetEventServer.Event.CHUNK_UNLOADED.onChunkEvent(level, levelChunk.getPos(), false);
        }
    }

    @Override
    @Unique
    public ServerLevelData getWorldPropertiesCM() {
        return this.serverLevelData;
    }

    @Override
    @Unique
    public LevelEntityGetter<Entity> getEntityLookupCMPublic() {
        return this.entityManager.getEntityGetter();
    }
}

