/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.ServerPlayerInteractionManagerInterface;
import carpet.script.CarpetEventServer;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public class ServerPlayerGameMode_scarpetEventsMixin
implements ServerPlayerInteractionManagerInterface {
    @Shadow
    public ServerPlayer player;
    @Shadow
    private boolean isDestroyingBlock;
    @Shadow
    private BlockPos destroyPos;
    @Shadow
    private int lastSentState;
    @Shadow
    public ServerLevel level;

    @Inject(method={"destroyBlock(Lnet/minecraft/core/BlockPos;)Z"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;removeBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)Z", shift=At.Shift.BEFORE)})
    private void onBlockBroken(BlockPos blockPos, CallbackInfoReturnable<Boolean> cir, @Local(ordinal=1) BlockState blockState) {
        if (CarpetEventServer.Event.PLAYER_BREAK_BLOCK.onBlockBroken(this.player, blockPos, blockState)) {
            this.level.sendBlockUpdated(blockPos, blockState, blockState, 3);
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"useItemOn(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/ItemUsedOnLocationTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;)V", shift=At.Shift.BEFORE)})
    private void onBlockActivated(ServerPlayer serverPlayerEntity, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        CarpetEventServer.Event.PLAYER_INTERACTS_WITH_BLOCK.onBlockHit(this.player, hand, hitResult);
    }

    @Override
    public BlockPos getCurrentBreakingBlock() {
        if (!this.isDestroyingBlock) {
            return null;
        }
        return this.destroyPos;
    }

    @Override
    public int getCurrentBlockBreakingProgress() {
        if (!this.isDestroyingBlock) {
            return -1;
        }
        return this.lastSentState;
    }

    @Override
    public void setBlockBreakingProgress(int progress) {
        this.lastSentState = Mth.clamp((int)progress, (int)-1, (int)10);
        this.level.destroyBlockProgress(-1 * this.player.getId(), this.destroyPos, this.lastSentState);
    }
}

