/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.EntityInterface;
import carpet.fakes.ServerPlayerInterface;
import carpet.script.CarpetEventServer;
import carpet.script.EntityEventsGroup;
import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayer_scarpetEventMixin
extends Player
implements ServerPlayerInterface {
    @Unique
    private boolean isInvalidReference = false;
    @Shadow
    public boolean wonGame;
    private Vec3 previousLocation;
    private ResourceKey<Level> previousDimension;

    public ServerPlayer_scarpetEventMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Redirect(method={"completeUsingItem()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;completeUsingItem()V"))
    private void finishedUsingItem(Player playerEntity) {
        if (CarpetEventServer.Event.PLAYER_FINISHED_USING_ITEM.isNeeded()) {
            InteractionHand hand = this.getUsedItemHand();
            if (!CarpetEventServer.Event.PLAYER_FINISHED_USING_ITEM.onItemAction((ServerPlayer)this, hand, this.getUseItem())) {
                super.completeUsingItem();
            }
        } else {
            super.completeUsingItem();
        }
    }

    @Inject(method={"awardStat(Lnet/minecraft/stats/Stat;I)V"}, at={@At(value="HEAD")})
    private void grabStat(Stat<?> stat, int amount, CallbackInfo ci) {
        CarpetEventServer.Event.STATISTICS.onPlayerStatistic((ServerPlayer)this, stat, amount);
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    private void onDeathEvent(DamageSource source, CallbackInfo ci) {
        ((EntityInterface)((Object)this)).getEventContainer().onEvent(EntityEventsGroup.Event.ON_DEATH, source.getMsgId());
        if (CarpetEventServer.Event.PLAYER_DIES.isNeeded()) {
            CarpetEventServer.Event.PLAYER_DIES.onPlayerEvent((ServerPlayer)this);
        }
    }

    @Redirect(method={"setPlayerInput(FFZZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setShiftKeyDown(Z)V"))
    private void setSneakingConditionally(ServerPlayer serverPlayerEntity, boolean sneaking) {
        if (!((EntityInterface)serverPlayerEntity.getVehicle()).isPermanentVehicle()) {
            serverPlayerEntity.setShiftKeyDown(sneaking);
        }
    }

    @Inject(method={"changeDimension(Lnet/minecraft/world/level/portal/DimensionTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="HEAD")})
    private void logPreviousCoordinates(DimensionTransition serverWorld, CallbackInfoReturnable<Entity> cir) {
        this.previousLocation = this.position();
        this.previousDimension = this.level().dimension();
    }

    @Inject(method={"changeDimension(Lnet/minecraft/world/level/portal/DimensionTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")})
    private void atChangeDimension(DimensionTransition destinationP, CallbackInfoReturnable<Entity> cir) {
        if (CarpetEventServer.Event.PLAYER_CHANGES_DIMENSION.isNeeded()) {
            ServerPlayer player = (ServerPlayer)this;
            DimensionTransition destinationTransition = destinationP;
            ServerLevel destination = destinationTransition.newLevel();
            Vec3 to = null;
            if (!this.wonGame || this.previousDimension != Level.END || destination.dimension() != Level.OVERWORLD) {
                to = this.position();
            }
            CarpetEventServer.Event.PLAYER_CHANGES_DIMENSION.onDimensionChange(player, this.previousLocation, to, this.previousDimension, (ResourceKey<Level>)destination.dimension());
        }
    }

    @Override
    public void invalidateEntityObjectReference() {
        this.isInvalidReference = true;
    }

    @Override
    public boolean isInvalidEntityObject() {
        return this.isInvalidReference;
    }
}

