/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.helpers.ParticleDisplay;
import carpet.utils.Messenger;
import carpet.utils.MobAI;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class Villager_aiMixin
extends AbstractVillager {
    int totalFood;
    boolean hasBed;
    int displayAge;

    @Shadow
    protected abstract void setUnhappy();

    @Shadow
    protected abstract int countFoodPointsInInventory();

    @Shadow
    public abstract void eatAndDigestFood();

    public Villager_aiMixin(EntityType<? extends AbstractVillager> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void ontick(CallbackInfo ci) {
        if (MobAI.isTracking((Entity)this, MobAI.TrackingType.IRON_GOLEM_SPAWNING)) {
            Optional last_seen = (Optional)this.brain.getMemories().get(MemoryModuleType.GOLEM_DETECTED_RECENTLY);
            long time = !last_seen.isPresent() ? 0L : ((ExpirableValue)last_seen.get()).getTimeToLive();
            boolean recentlySeen = time > 0L;
            Optional optional_11 = this.brain.getMemory(MemoryModuleType.LAST_SLEPT);
            boolean sleep = false;
            boolean panic = this.brain.isActive(Activity.PANIC);
            long currentTime = this.level().getGameTime();
            if (optional_11.isPresent()) {
                sleep = currentTime - (Long)optional_11.get() < 24000L;
            }
            this.setCustomName(Messenger.c((sleep ? "eb " : "fb ") + "\u263d ", (panic ? "lb " : "fb ") + "\u2623 ", (recentlySeen ? "rb " : "lb ") + time));
            this.setCustomNameVisible(true);
        } else if (MobAI.isTracking((Entity)this, MobAI.TrackingType.BREEDING)) {
            if (this.tickCount % 50 == 0 || this.tickCount < 20) {
                this.totalFood = this.countFoodPointsInInventory() / 12;
                this.hasBed = this.brain.getMemory(MemoryModuleType.HOME).isPresent();
                this.displayAge = this.getAge();
            }
            if (Math.abs(this.displayAge) < 100 && this.displayAge != 0) {
                this.displayAge = this.getAge();
            }
            this.setCustomName(Messenger.c((this.hasBed ? "eb " : "fb ") + "\u2616 ", (this.totalFood > 0 ? "eb " : "fb ") + "\u2668", (this.totalFood > 0 ? "e " : "f ") + this.totalFood + " ", (this.displayAge == 0 ? "eb " : "fb ") + "\u2661", this.displayAge == 0 ? "e " : "f " + this.displayAge));
            this.setCustomNameVisible(true);
        }
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteract(Player playerEntity_1, InteractionHand hand_1, CallbackInfoReturnable<InteractionResult> cir) {
        if (MobAI.isTracking((Entity)this, MobAI.TrackingType.BREEDING)) {
            ItemStack itemStack_1 = playerEntity_1.getItemInHand(hand_1);
            if (itemStack_1.getItem() == Items.EMERALD) {
                GlobalPos bedPos = this.brain.getMemory(MemoryModuleType.HOME).orElse(null);
                if (bedPos == null || bedPos.dimension() != this.level().dimension()) {
                    this.setUnhappy();
                    ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, Blocks.BARRIER.defaultBlockState()), this.getX(), this.getY() + (double)this.getEyeHeight() + 1.0, this.getZ(), 1, 0.1, 0.1, 0.1, 0.0);
                } else {
                    ParticleDisplay.drawParticleLine((ServerPlayer)playerEntity_1, this.position(), Vec3.atCenterOf((Vec3i)bedPos.pos()), "dust 0 0 0 1", "happy_villager", 100, 0.2);
                }
            } else if (itemStack_1.getItem() == Items.ROTTEN_FLESH) {
                while (this.countFoodPointsInInventory() >= 12) {
                    this.eatAndDigestFood();
                }
            } else if (itemStack_1.getItem() instanceof BedItem) {
                List list_1 = ((ServerLevel)this.getCommandSenderWorld()).getPoiManager().getInRange(type -> type.is(PoiTypes.HOME), this.blockPosition(), 48, PoiManager.Occupancy.ANY).toList();
                for (PoiRecord poi : list_1) {
                    Vec3 pv = Vec3.atCenterOf((Vec3i)poi.getPos());
                    if (!poi.hasSpace()) {
                        ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, pv.x, pv.y + 1.5, pv.z, 50, 0.1, 0.3, 0.1, 0.0);
                        continue;
                    }
                    if (this.canReachHome((Villager)this, poi.getPos(), poi)) {
                        ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.END_ROD, pv.x, pv.y + 1.0, pv.z, 50, 0.1, 0.3, 0.1, 0.0);
                        continue;
                    }
                    ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, Blocks.BARRIER.defaultBlockState()), pv.x, pv.y + 1.0, pv.z, 1, 0.1, 0.1, 0.1, 0.0);
                }
            }
            cir.setReturnValue((Object)InteractionResult.FAIL);
            cir.cancel();
        }
    }

    private boolean canReachHome(Villager villager, BlockPos pos, PoiRecord poi) {
        Path path = villager.getNavigation().createPath(pos, ((PoiType)poi.getPoiType().value()).validRange());
        return path != null && path.canReach();
    }

    @Inject(method={"spawnGolemIfNeeded(Lnet/minecraft/server/level/ServerLevel;JI)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", shift=At.Shift.AFTER)})
    private void particleIt(ServerLevel serverWorld, long l, int i, CallbackInfo ci) {
        if (MobAI.isTracking((Entity)this, MobAI.TrackingType.IRON_GOLEM_SPAWNING)) {
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, Blocks.BARRIER.defaultBlockState()), this.getX(), this.getY() + 3.0, this.getZ(), 1, 0.1, 0.1, 0.1, 0.0);
        }
    }
}

