/*
 * Decompiled with CFR 0.152.
 */
package carpet.patches;

import carpet.CarpetSettings;
import carpet.fakes.ServerPlayerInterface;
import carpet.patches.FakeClientConnection;
import carpet.utils.Messenger;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class EntityPlayerMPFake
extends ServerPlayer {
    public Runnable fixStartingPosition = () -> {};
    public boolean isAShadow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createFake(String username, MinecraftServer server, Vec3 pos, double yaw, double pitch, ResourceKey<Level> dimensionId, GameType gamemode, boolean flying) {
        GameProfile gameprofile;
        ServerLevel worldIn = server.getLevel(dimensionId);
        GameProfileCache.setUsesAuthentication((boolean)false);
        try {
            gameprofile = server.getProfileCache().get(username).orElse(null);
        }
        catch (Throwable throwable) {
            GameProfileCache.setUsesAuthentication((server.isDedicatedServer() && server.usesAuthentication() ? 1 : 0) != 0);
            throw throwable;
        }
        GameProfileCache.setUsesAuthentication((server.isDedicatedServer() && server.usesAuthentication() ? 1 : 0) != 0);
        if (gameprofile == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                return false;
            }
            gameprofile = new GameProfile(UUIDUtil.createOfflinePlayerUUID((String)username), username);
        }
        GameProfile finalGP = gameprofile;
        EntityPlayerMPFake.fetchGameProfile(gameprofile.getName()).thenAcceptAsync(p -> {
            GameProfile current = finalGP;
            if (p.isPresent()) {
                current = (GameProfile)p.get();
            }
            EntityPlayerMPFake instance = new EntityPlayerMPFake(server, worldIn, current, ClientInformation.createDefault(), false);
            instance.fixStartingPosition = () -> instance.moveTo(pos.x, pos.y, pos.z, (float)yaw, (float)pitch);
            server.getPlayerList().placeNewPlayer((Connection)new FakeClientConnection(PacketFlow.SERVERBOUND), (ServerPlayer)instance, new CommonListenerCookie(current, 0, instance.clientInformation(), false));
            instance.teleportTo(worldIn, pos.x, pos.y, pos.z, (float)yaw, (float)pitch);
            instance.setHealth(20.0f);
            instance.unsetRemoved();
            instance.getAttribute(Attributes.STEP_HEIGHT).setBaseValue((double)0.6f);
            instance.gameMode.changeGameModeForPlayer(gamemode);
            server.getPlayerList().broadcastAll((Packet)new ClientboundRotateHeadPacket((Entity)instance, (byte)(instance.yHeadRot * 256.0f / 360.0f)), dimensionId);
            server.getPlayerList().broadcastAll((Packet)new ClientboundTeleportEntityPacket((Entity)instance), dimensionId);
            instance.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)127);
            instance.getAbilities().flying = flying;
        }, (Executor)server);
        return true;
    }

    private static CompletableFuture<Optional<GameProfile>> fetchGameProfile(String name) {
        return SkullBlockEntity.fetchGameProfile((String)name);
    }

    public static EntityPlayerMPFake createShadow(MinecraftServer server, ServerPlayer player) {
        player.getServer().getPlayerList().remove(player);
        player.connection.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.duplicate_login"));
        ServerLevel worldIn = player.serverLevel();
        GameProfile gameprofile = player.getGameProfile();
        EntityPlayerMPFake playerShadow = new EntityPlayerMPFake(server, worldIn, gameprofile, player.clientInformation(), true);
        playerShadow.setChatSession(player.getChatSession());
        server.getPlayerList().placeNewPlayer((Connection)new FakeClientConnection(PacketFlow.SERVERBOUND), (ServerPlayer)playerShadow, new CommonListenerCookie(gameprofile, 0, player.clientInformation(), true));
        playerShadow.setHealth(player.getHealth());
        playerShadow.connection.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
        playerShadow.gameMode.changeGameModeForPlayer(player.gameMode.getGameModeForPlayer());
        ((ServerPlayerInterface)((Object)playerShadow)).getActionPack().copyFrom(((ServerPlayerInterface)player).getActionPack());
        playerShadow.getAttribute(Attributes.STEP_HEIGHT).setBaseValue((double)0.6f);
        playerShadow.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)((Byte)player.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION)));
        server.getPlayerList().broadcastAll((Packet)new ClientboundRotateHeadPacket((Entity)playerShadow, (byte)(player.yHeadRot * 256.0f / 360.0f)), playerShadow.level().dimension());
        server.getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)playerShadow));
        playerShadow.getAbilities().flying = player.getAbilities().flying;
        return playerShadow;
    }

    public static EntityPlayerMPFake respawnFake(MinecraftServer server, ServerLevel level, GameProfile profile, ClientInformation cli) {
        return new EntityPlayerMPFake(server, level, profile, cli, false);
    }

    private EntityPlayerMPFake(MinecraftServer server, ServerLevel worldIn, GameProfile profile, ClientInformation cli, boolean shadow) {
        super(server, worldIn, profile, cli);
        this.isAShadow = shadow;
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack previous, ItemStack stack) {
        if (!this.isUsingItem()) {
            super.onEquipItem(slot, previous, stack);
        }
    }

    public void kill() {
        this.kill(Messenger.s("Killed"));
    }

    public void kill(Component reason) {
        TranslatableContents text;
        this.shakeOff();
        ComponentContents componentContents = reason.getContents();
        if (componentContents instanceof TranslatableContents && (text = (TranslatableContents)componentContents).getKey().equals("multiplayer.disconnect.duplicate_login")) {
            this.connection.onDisconnect(new DisconnectionDetails(reason));
        } else {
            this.server.tell((Runnable)new TickTask(this.server.getTickCount(), () -> this.connection.onDisconnect(new DisconnectionDetails(reason))));
        }
    }

    public void tick() {
        if (this.getServer().getTickCount() % 10 == 0) {
            this.connection.resetPosition();
            this.serverLevel().getChunkSource().move((ServerPlayer)this);
        }
        try {
            super.tick();
            this.doTick();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void shakeOff() {
        if (this.getVehicle() instanceof Player) {
            this.stopRiding();
        }
        for (Entity passenger : this.getIndirectPassengers()) {
            if (!(passenger instanceof Player)) continue;
            passenger.stopRiding();
        }
    }

    public void die(DamageSource cause) {
        this.shakeOff();
        super.die(cause);
        this.setHealth(20.0f);
        this.foodData = new FoodData();
        this.kill(this.getCombatTracker().getDeathMessage());
    }

    public String getIpAddress() {
        return "127.0.0.1";
    }

    public boolean allowsListing() {
        return CarpetSettings.allowListingFakePlayers;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.doCheckFallDamage(0.0, y, 0.0, onGround);
    }

    public Entity changeDimension(DimensionTransition serverLevel) {
        super.changeDimension(serverLevel);
        if (this.wonGame) {
            ServerboundClientCommandPacket p = new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN);
            this.connection.handleClientCommand(p);
        }
        if (this.connection.player.isChangingDimension()) {
            this.connection.player.hasChangedDimension();
        }
        return this.connection.player;
    }
}

