/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.Context;
import carpet.script.annotation.SimpleTypeConverter;
import carpet.script.annotation.ValueConverter;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public interface Param {

    public static final class Params {
        static final ValueConverter<Context> CONTEXT_PROVIDER = new ValueConverter<Context>(){

            @Override
            @Nullable
            public String getTypeName() {
                return null;
            }

            @Override
            public Context convert(Value value, @Nullable Context context) {
                throw new UnsupportedOperationException("Called convert() with Value in Context Provider converter, where only checkAndConvert is supported");
            }

            @Override
            public Context checkAndConvert(Iterator<Value> valueIterator, Context context, Context.Type theLazyT) {
                return context;
            }

            @Override
            public int valueConsumption() {
                return 0;
            }
        };
        static final ValueConverter<Context.Type> CONTEXT_TYPE_PROVIDER = new ValueConverter<Context.Type>(){

            @Override
            @Nullable
            public String getTypeName() {
                return null;
            }

            @Override
            public Context.Type convert(Value value, @Nullable Context context) {
                throw new UnsupportedOperationException("Called convert() with a Value in TheLazyT Provider, where only checkAndConvert is supported");
            }

            @Override
            public Context.Type checkAndConvert(Iterator<Value> valueIterator, Context context, Context.Type theLazyT) {
                return theLazyT;
            }

            @Override
            public int valueConsumption() {
                return 0;
            }
        };
        private static final Map<StrictConverterInfo, ValueConverter<?>> strictParamsByClassAndShallowness = new HashMap();
        private static final List<BiFunction<AnnotatedType, Class<?>, ValueConverter<?>>> customFactories;

        static ValueConverter<?> getStrictConverter(AnnotatedType type) {
            boolean shallow = type.getAnnotation(Strict.class).shallow();
            Class clazz = (Class)type.getType();
            StrictConverterInfo key = new StrictConverterInfo(clazz, shallow);
            ValueConverter<?> converter = strictParamsByClassAndShallowness.get(key);
            if (converter != null) {
                return converter;
            }
            throw new IllegalArgumentException("Incorrect use of @Param.Strict annotation");
        }

        public static <T> void registerStrictConverter(Class<T> type, boolean shallow, ValueConverter<T> converter) {
            StrictConverterInfo key = new StrictConverterInfo(type, shallow);
            if (strictParamsByClassAndShallowness.containsKey(key)) {
                throw new IllegalArgumentException(String.valueOf(type) + " already has a registered " + (shallow ? "" : "non-") + "shallow StrictConverter");
            }
            strictParamsByClassAndShallowness.put(key, converter);
        }

        public static <T> void registerCustomConverterFactory(BiFunction<AnnotatedType, Class<T>, ValueConverter<T>> factory) {
            customFactories.add(factory);
        }

        static <R> ValueConverter<R> getCustomConverter(AnnotatedType annoType, Class<R> type) {
            for (BiFunction<AnnotatedType, Class<?>, ValueConverter<?>> factory : customFactories) {
                ValueConverter<?> result = factory.apply(annoType, type);
                if (result == null) continue;
                return result;
            }
            throw new IllegalArgumentException("No custom converter found for Param.Custom annotated param with type " + annoType.getType().getTypeName());
        }

        static {
            Params.registerStrictConverter(String.class, false, new SimpleTypeConverter<StringValue, String>(StringValue.class, StringValue::getString, "string"));
            Params.registerStrictConverter(Component.class, false, new SimpleTypeConverter<FormattedTextValue, Component>(FormattedTextValue.class, FormattedTextValue::getText, "text"));
            Params.registerStrictConverter(Component.class, true, new SimpleTypeConverter<StringValue, Component>(StringValue.class, FormattedTextValue::getTextByValue, "text"));
            Params.registerStrictConverter(ServerPlayer.class, false, new SimpleTypeConverter<EntityValue, ServerPlayer>(EntityValue.class, v -> EntityValue.getPlayerByValue(v.getEntity().getServer(), v), "online player entity"));
            Params.registerStrictConverter(Boolean.class, false, new SimpleTypeConverter<BooleanValue, Boolean>(BooleanValue.class, NumericValue::getBoolean, "boolean"));
            Params.registerStrictConverter(Boolean.class, true, new SimpleTypeConverter<NumericValue, Boolean>(NumericValue.class, NumericValue::getBoolean, "boolean"));
            customFactories = new ArrayList();
        }

        record StrictConverterInfo(Class<?> type, boolean shallow) {
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.TYPE_USE})
    public static @interface Strict {
        public boolean shallow() default false;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.TYPE_USE})
    public static @interface Custom {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.TYPE_USE})
    public static @interface KeyValuePairs {
        public boolean allowMultiparam() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.TYPE_USE})
    public static @interface AllowSingleton {
    }
}

