/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Module;
import carpet.script.argument.FunctionArgument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.InputValidator;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ScreenValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Inventories {
    public static void apply(Expression expression) {
        expression.addContextFunction("stack_limit", 1, (c, t, lv) -> new NumericValue(NBTSerializableValue.parseItem(((Value)lv.get(0)).getString(), ((CarpetContext)c).registryAccess()).getMaxStackSize()));
        expression.addContextFunction("item_category", -1, (c, t, lv) -> {
            c.host.issueDeprecation("item_category in 1.19.3+");
            return Value.NULL;
        });
        expression.addContextFunction("item_list", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry items = cc.registry(Registries.ITEM);
            if (lv.isEmpty()) {
                return ListValue.wrap(items.holders().map(itemReference -> ValueConversions.of(itemReference.key().location())));
            }
            String tag = ((Value)lv.get(0)).getString();
            Optional itemTag = items.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)InputValidator.identifierOf(tag)));
            return itemTag.isEmpty() ? Value.NULL : ListValue.wrap(((HolderSet.Named)itemTag.get()).stream().map(b -> items.getKey((Object)((Item)b.value()))).filter(Objects::nonNull).map(ValueConversions::of));
        });
        expression.addContextFunction("item_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry blocks = cc.registry(Registries.ITEM);
            if (lv.isEmpty()) {
                return ListValue.wrap(blocks.getTagNames().map(ValueConversions::of));
            }
            Item item = NBTSerializableValue.parseItem(((Value)lv.get(0)).getString(), cc.registryAccess()).getItem();
            if (lv.size() == 1) {
                return ListValue.wrap(blocks.getTags().filter(e -> ((HolderSet.Named)e.getSecond()).stream().anyMatch(h -> h.value() == item)).map(e -> ValueConversions.of((TagKey)e.getFirst())));
            }
            String tag = ((Value)lv.get(1)).getString();
            Optional tagSet = blocks.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)InputValidator.identifierOf(tag)));
            return tagSet.isEmpty() ? Value.NULL : BooleanValue.of(((HolderSet.Named)tagSet.get()).stream().anyMatch(h -> h.value() == item));
        });
        expression.addContextFunction("recipe_data", -1, (c, t, lv) -> {
            List<Recipe<?>> recipes;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 1) {
                throw new InternalExpressionException("'recipe_data' requires at least one argument");
            }
            String recipeName = ((Value)lv.get(0)).getString();
            RecipeType type = RecipeType.CRAFTING;
            if (lv.size() > 1) {
                String recipeType = ((Value)lv.get(1)).getString();
                type = (RecipeType)cc.registry(Registries.RECIPE_TYPE).get(InputValidator.identifierOf(recipeType));
                if (type == null) {
                    throw new InternalExpressionException("Unknown recipe type: " + recipeType);
                }
            }
            if ((recipes = Vanilla.RecipeManager_getAllMatching(cc.server().getRecipeManager(), type, InputValidator.identifierOf(recipeName), cc.registryAccess())).isEmpty()) {
                return Value.NULL;
            }
            ArrayList<Value> recipesOutput = new ArrayList<Value>();
            RegistryAccess regs = cc.registryAccess();
            for (Recipe<?> recipe : recipes) {
                ListValue recipeSpec;
                ItemStack result = recipe.getResultItem((HolderLookup.Provider)regs);
                ArrayList<Value> ingredientValue = new ArrayList<Value>();
                recipe.getIngredients().forEach(ingredient -> {
                    List<Collection<ItemStack>> stacks = Vanilla.Ingredient_getRecipeStacks(ingredient);
                    if (stacks.isEmpty()) {
                        ingredientValue.add(Value.NULL);
                    } else {
                        ArrayList<Value> alternatives = new ArrayList<Value>();
                        stacks.forEach(col -> col.stream().map(is -> ValueConversions.of(is, regs)).forEach(alternatives::add));
                        ingredientValue.add(ListValue.wrap(alternatives));
                    }
                });
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    recipeSpec = ListValue.of(new StringValue("shaped"), new NumericValue(shapedRecipe.getWidth()), new NumericValue(shapedRecipe.getHeight()));
                } else if (recipe instanceof ShapelessRecipe) {
                    recipeSpec = ListValue.of(new StringValue("shapeless"));
                } else if (recipe instanceof AbstractCookingRecipe) {
                    AbstractCookingRecipe abstractCookingRecipe = (AbstractCookingRecipe)recipe;
                    recipeSpec = ListValue.of(new StringValue("smelting"), new NumericValue(abstractCookingRecipe.getCookingTime()), new NumericValue(abstractCookingRecipe.getExperience()));
                } else {
                    recipeSpec = recipe instanceof SingleItemRecipe ? ListValue.of(new StringValue("cutting")) : (recipe instanceof CustomRecipe ? ListValue.of(new StringValue("special")) : ListValue.of(new StringValue("custom")));
                }
                recipesOutput.add(ListValue.of(ValueConversions.of(result, regs), ListValue.wrap(ingredientValue), recipeSpec));
            }
            return ListValue.wrap(recipesOutput);
        });
        expression.addContextFunction("crafting_remaining_item", 1, (c, t, v) -> {
            String itemStr = ((Value)v.get(0)).getString();
            ResourceLocation id = InputValidator.identifierOf(itemStr);
            Registry registry = ((CarpetContext)c).registry(Registries.ITEM);
            Item item = (Item)registry.getOptional(id).orElseThrow(() -> new ThrowStatement(itemStr, Throwables.UNKNOWN_ITEM));
            Item reminder = item.getCraftingRemainingItem();
            return reminder == null ? Value.NULL : NBTSerializableValue.nameFromRegistryId(registry.getKey((Object)reminder));
        });
        expression.addContextFunction("inventory_size", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            return inventoryLocator == null ? Value.NULL : new NumericValue(inventoryLocator.inventory().getContainerSize());
        });
        expression.addContextFunction("inventory_has_items", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            return inventoryLocator == null ? Value.NULL : BooleanValue.of(!inventoryLocator.inventory().isEmpty());
        });
        expression.addContextFunction("inventory_get", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            RegistryAccess regs = cc.registryAccess();
            if (lv.size() == inventoryLocator.offset()) {
                ArrayList<Value> fullInventory = new ArrayList<Value>();
                int maxi = inventoryLocator.inventory().getContainerSize();
                for (int i = 0; i < maxi; ++i) {
                    fullInventory.add(ValueConversions.of(inventoryLocator.inventory().getItem(i), regs));
                }
                return ListValue.wrap(fullInventory);
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            return (slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().getContainerSize() ? Value.NULL : ValueConversions.of(inventoryLocator.inventory().getItem(slot), regs);
        });
        expression.addContextFunction("inventory_set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() < inventoryLocator.offset() + 2) {
                throw new InternalExpressionException("'inventory_set' requires at least slot number and new stack size, and optional new item");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().getContainerSize()) {
                return Value.NULL;
            }
            OptionalInt count = OptionalInt.empty();
            Value countVal = (Value)lv.get(inventoryLocator.offset() + 1);
            if (!countVal.isNull()) {
                count = OptionalInt.of((int)NumericValue.asNumber(countVal).getLong());
            }
            RegistryAccess regs = cc.registryAccess();
            if (count.isPresent() && count.getAsInt() == 0) {
                ItemStack removedStack = inventoryLocator.inventory().removeItemNoUpdate(slot);
                Inventories.syncPlayerInventory(inventoryLocator);
                return ValueConversions.of(removedStack, regs);
            }
            if (lv.size() < inventoryLocator.offset() + 3) {
                ItemStack previousStack = inventoryLocator.inventory().getItem(slot);
                ItemStack newStack = previousStack.copy();
                count.ifPresent(arg_0 -> ((ItemStack)newStack).setCount(arg_0));
                inventoryLocator.inventory().setItem(slot, newStack);
                Inventories.syncPlayerInventory(inventoryLocator);
                return ValueConversions.of(previousStack, regs);
            }
            CompoundTag nbt = null;
            if (lv.size() > inventoryLocator.offset() + 3) {
                Value nbtValue = (Value)lv.get(inventoryLocator.offset() + 3);
                if (nbtValue instanceof NBTSerializableValue) {
                    NBTSerializableValue nbtsv = (NBTSerializableValue)nbtValue;
                    nbt = nbtsv.getCompoundTag();
                } else if (!nbtValue.isNull()) {
                    nbt = new NBTSerializableValue(nbtValue.getString()).getCompoundTag();
                }
            }
            ItemStack newitem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset() + 2)).getString(), nbt, cc.registryAccess());
            count.ifPresent(arg_0 -> ((ItemStack)newitem).setCount(arg_0));
            ItemStack previousStack = inventoryLocator.inventory().getItem(slot);
            inventoryLocator.inventory().setItem(slot, newitem);
            Inventories.syncPlayerInventory(inventoryLocator);
            return ValueConversions.of(previousStack, regs);
        });
        expression.addContextFunction("inventory_find", -1, (c, t, lv) -> {
            Value secondArg;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            ItemStack itemArg = null;
            if (lv.size() > inventoryLocator.offset() && !(secondArg = (Value)lv.get(inventoryLocator.offset())).isNull()) {
                itemArg = NBTSerializableValue.parseItem(secondArg.getString(), cc.registryAccess());
            }
            int startIndex = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                startIndex = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            int maxi = inventoryLocator.inventory().getContainerSize();
            for (int i = startIndex = NBTSerializableValue.validateSlot(startIndex, inventoryLocator.inventory()); i < maxi; ++i) {
                ItemStack stack = inventoryLocator.inventory().getItem(i);
                if ((itemArg != null || !stack.isEmpty()) && (itemArg == null || !itemArg.getItem().equals(stack.getItem()))) continue;
                return new NumericValue(i);
            }
            return Value.NULL;
        });
        expression.addContextFunction("inventory_remove", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() <= inventoryLocator.offset()) {
                throw new InternalExpressionException("'inventory_remove' requires at least an item to be removed");
            }
            ItemStack searchItem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset())).getString(), cc.registryAccess());
            int amount = 1;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount == 1 && !inventoryLocator.inventory().hasAnyOf(Set.of(searchItem.getItem())) || inventoryLocator.inventory().countItem(searchItem.getItem()) < amount) {
                return Value.FALSE;
            }
            int maxi = inventoryLocator.inventory().getContainerSize();
            for (int i = 0; i < maxi; ++i) {
                ItemStack stack = inventoryLocator.inventory().getItem(i);
                if (stack.isEmpty() || !stack.getItem().equals(searchItem.getItem())) continue;
                int left = stack.getCount() - amount;
                if (left > 0) {
                    stack.setCount(left);
                    inventoryLocator.inventory().setItem(i, stack);
                    Inventories.syncPlayerInventory(inventoryLocator);
                    return Value.TRUE;
                }
                inventoryLocator.inventory().removeItemNoUpdate(i);
                Inventories.syncPlayerInventory(inventoryLocator);
                amount -= stack.getCount();
            }
            if (amount > 0) {
                throw new InternalExpressionException("Something bad happened - cannot pull all items from inventory");
            }
            return Value.TRUE;
        });
        expression.addContextFunction("drop_item", -1, (c, t, lv) -> {
            ItemEntity item;
            ItemStack droppedStack;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() == inventoryLocator.offset()) {
                throw new InternalExpressionException("Slot number is required for inventory_drop");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().getContainerSize()) {
                return Value.NULL;
            }
            int amount = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount < 0) {
                throw new InternalExpressionException("Cannot throw negative number of items");
            }
            ItemStack stack = inventoryLocator.inventory().getItem(slot);
            if (stack == null || stack.isEmpty()) {
                return Value.ZERO;
            }
            if (amount == 0) {
                amount = stack.getCount();
            }
            if ((droppedStack = inventoryLocator.inventory().removeItem(slot, amount)).isEmpty()) {
                return Value.ZERO;
            }
            Object owner = inventoryLocator.owner();
            if (owner instanceof Player) {
                Player player = (Player)owner;
                item = player.drop(droppedStack, false, true);
                if (item == null) {
                    return Value.ZERO;
                }
            } else if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                double dropY = livingEntity.getY() - (double)0.3f + (double)livingEntity.getEyeHeight();
                item = new ItemEntity(livingEntity.level(), livingEntity.getX(), dropY, livingEntity.getZ(), droppedStack);
                Vec3 vec3d = livingEntity.getViewVector(1.0f).normalize().scale(0.3);
                item.setDeltaMovement(vec3d);
                item.setDefaultPickUpDelay();
                cc.level().addFreshEntity((Entity)item);
            } else {
                Vec3 point = Vec3.atCenterOf((Vec3i)inventoryLocator.position());
                item = new ItemEntity((Level)cc.level(), point.x, point.y, point.z, droppedStack);
                item.setDefaultPickUpDelay();
                cc.level().addFreshEntity((Entity)item);
            }
            return new NumericValue(item.getItem().getCount());
        });
        expression.addContextFunction("create_screen", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'create_screen' requires at least three arguments");
            }
            Value playerValue = (Value)lv.get(0);
            ServerPlayer player = EntityValue.getPlayerByValue(((CarpetContext)c).server(), playerValue);
            if (player == null) {
                throw new InternalExpressionException("'create_screen' requires a valid online player as the first argument.");
            }
            String type = ((Value)lv.get(1)).getString();
            Component name = FormattedTextValue.getTextByValue((Value)lv.get(2));
            FunctionValue function = null;
            if (lv.size() > 3) {
                function = FunctionArgument.findIn((Context)c, (Module)expression.module, (List<Value>)lv, (int)3, (boolean)true, (boolean)false).function;
            }
            return new ScreenValue(player, type, name, function, (Context)c);
        });
        expression.addContextFunction("close_screen", 1, (c, t, lv) -> {
            Value value = (Value)lv.get(0);
            if (!(value instanceof ScreenValue)) {
                throw new InternalExpressionException("'close_screen' requires a screen value as the first argument.");
            }
            ScreenValue screenValue = (ScreenValue)value;
            if (!screenValue.isOpen()) {
                return Value.FALSE;
            }
            screenValue.close();
            return Value.TRUE;
        });
        expression.addContextFunction("screen_property", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'screen_property' requires at least a screen and a property name");
            }
            Object patt0$temp = lv.get(0);
            if (!(patt0$temp instanceof ScreenValue)) {
                throw new InternalExpressionException("'screen_property' requires a screen value as the first argument");
            }
            ScreenValue screenValue = (ScreenValue)patt0$temp;
            String propertyName = ((Value)lv.get(1)).getString();
            return lv.size() >= 3 ? screenValue.modifyProperty(propertyName, lv.subList(2, lv.size())) : screenValue.queryProperty(propertyName);
        });
    }

    private static void syncPlayerInventory(NBTSerializableValue.InventoryLocator inventory) {
        Object object = inventory.owner();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            if (!inventory.isEnder() && !(inventory.inventory() instanceof ScreenValue.ScreenHandlerInventory)) {
                player.containerMenu.broadcastChanges();
            }
        }
    }
}

