/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;

public class ParticleParser {
    private static final Map<String, ParticleOptions> particleCache = new HashMap<String, ParticleOptions>();

    private static ParticleOptions parseParticle(String name, RegistryAccess lookup) {
        try {
            return ParticleArgument.readParticle((StringReader)new StringReader(name), (HolderLookup.Provider)lookup);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("No such particle: " + name);
        }
    }

    @Nullable
    public static ParticleOptions getEffect(@Nullable String name, RegistryAccess lookup) {
        if (name == null) {
            return null;
        }
        return particleCache.computeIfAbsent(name, particle -> ParticleParser.parseParticle(particle, lookup));
    }

    public static void resetCache() {
        particleCache.clear();
    }
}

