/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetServer;
import carpet.utils.Translations;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thinkingstudio.bedsheet.loader.FoxifiedLoader;
import org.thinkingstudio.bedsheet.loader.entrypoint.DedicatedServerModInitializer;

public class CarpetRulePrinter
implements DedicatedServerModInitializer {
    @Override
    public void onInitializeServer() {
        PrintStream outputStream;
        String[] args = (String[])Arrays.stream(FoxifiedLoader.getLaunchArguments(true)).filter(opt -> !opt.equals("--")).toArray(String[]::new);
        OptionParser parser = new OptionParser();
        OptionSpecBuilder shouldDump = parser.accepts("carpetDumpRules");
        ArgumentAcceptingOptionSpec pathSpec = parser.accepts("dumpPath").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec filterSpec = parser.accepts("dumpFilter").withRequiredArg();
        parser.allowsUnrecognizedOptions();
        OptionSet options = parser.parse(args);
        if (!options.has((OptionSpec)shouldDump)) {
            return;
        }
        Logger logger = LoggerFactory.getLogger((String)"Carpet Rule Printer");
        logger.info("Starting in rule dump mode...");
        try {
            Path path = ((Path)options.valueOf((OptionSpec)pathSpec)).toAbsolutePath();
            logger.info("Printing rules to: " + String.valueOf(path));
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            outputStream = new PrintStream(Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Translations.updateLanguage();
        String filter = (String)options.valueOf((OptionSpec)filterSpec);
        if (filter != null) {
            logger.info("Applying category filter: " + filter);
        }
        CarpetServer.settingsManager.dumpAllRulesToStream(outputStream, filter);
        outputStream.close();
        logger.info("Rules have been printed");
        System.exit(0);
    }
}

