/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.apache.commons.lang3.tuple.Pair;

public class SpawnOverrides {
    private static final Map<Pair<MobCategory, ResourceKey<Structure>>, Pair<BooleanSupplier, StructureSpawnOverride>> carpetOverrides = new HashMap<Pair<MobCategory, ResourceKey<Structure>>, Pair<BooleanSupplier, StructureSpawnOverride>>();

    public static void addOverride(BooleanSupplier when, MobCategory cat, ResourceKey<Structure> poo, StructureSpawnOverride.BoundingBoxType type, WeightedRandomList<MobSpawnSettings.SpawnerData> spawns) {
        carpetOverrides.put((Pair<MobCategory, ResourceKey<Structure>>)Pair.of((Object)cat, poo), (Pair<BooleanSupplier, StructureSpawnOverride>)Pair.of((Object)when, (Object)new StructureSpawnOverride(type, spawns)));
    }

    public static WeightedRandomList<MobSpawnSettings.SpawnerData> test(StructureManager structureFeatureManager, LongSet foo, MobCategory cat, Structure confExisting, BlockPos where) {
        ResourceLocation resource = structureFeatureManager.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)confExisting);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)resource);
        Pair<BooleanSupplier, StructureSpawnOverride> spawnData = carpetOverrides.get(Pair.of((Object)cat, (Object)key));
        if (spawnData == null || !((BooleanSupplier)spawnData.getKey()).getAsBoolean()) {
            return null;
        }
        StructureSpawnOverride override = (StructureSpawnOverride)spawnData.getRight();
        if (override.boundingBox() == StructureSpawnOverride.BoundingBoxType.STRUCTURE) {
            if (structureFeatureManager.getStructureAt(where, confExisting).isValid()) {
                return override.spawns();
            }
        } else {
            ArrayList starts = new ArrayList(1);
            structureFeatureManager.fillStartsForStructure(confExisting, foo, starts::add);
            for (StructureStart start : starts) {
                if (start == null || !start.isValid() || !structureFeatureManager.structureHasPieceAt(where, start)) continue;
                return override.spawns();
            }
        }
        return null;
    }

    public static boolean isStructureAtPosition(ServerLevel level, ResourceKey<Structure> structureKey, BlockPos pos) {
        Structure fortressFeature = (Structure)level.registryAccess().registryOrThrow(Registries.STRUCTURE).get(structureKey);
        if (fortressFeature == null) {
            return false;
        }
        return level.structureManager().getStructureAt(pos, fortressFeature).isValid();
    }

    public static List<StructureStart> startsForFeature(ServerLevel level, SectionPos sectionPos, StructureType<?> structure) {
        Map allrefs = level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
        ArrayList<StructureStart> result = new ArrayList<StructureStart>();
        for (Map.Entry entry : allrefs.entrySet()) {
            Structure existing = (Structure)entry.getKey();
            if (existing.type() != structure) continue;
            level.structureManager().fillStartsForStructure(existing, (LongSet)entry.getValue(), result::add);
        }
        return result;
    }

    static {
        SpawnOverrides.addOverride(() -> CarpetSettings.huskSpawningInTemples, MobCategory.MONSTER, (ResourceKey<Structure>)BuiltinStructures.DESERT_PYRAMID, StructureSpawnOverride.BoundingBoxType.STRUCTURE, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.HUSK, 1, 1, 1)}));
        SpawnOverrides.addOverride(() -> CarpetSettings.shulkerSpawningInEndCities, MobCategory.MONSTER, (ResourceKey<Structure>)BuiltinStructures.END_CITY, StructureSpawnOverride.BoundingBoxType.PIECE, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.SHULKER, 10, 4, 4)}));
        SpawnOverrides.addOverride(() -> CarpetSettings.piglinsSpawningInBastions, MobCategory.MONSTER, (ResourceKey<Structure>)BuiltinStructures.BASTION_REMNANT, StructureSpawnOverride.BoundingBoxType.PIECE, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.PIGLIN_BRUTE, 5, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.PIGLIN, 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.HOGLIN, 2, 1, 2)}));
    }
}

