/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.bedsheet.loader.entrypoint;

import java.util.Optional;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLLoader;
import org.thinkingstudio.bedsheet.loader.entrypoint.ClientModInitializer;
import org.thinkingstudio.bedsheet.loader.entrypoint.DedicatedServerModInitializer;
import org.thinkingstudio.bedsheet.loader.entrypoint.ModInitializer;

public class EntrypointHandler {
    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(FMLLoadCompleteEvent.class, event -> ModList.get().forEachModContainer((modId, modContainer) -> {
            Optional modInitializer = modContainer.getCustomExtension(ModInitializer.class);
            modInitializer.ifPresent(ModInitializer::onInitialize);
            if (FMLLoader.getDist().isDedicatedServer()) {
                Optional serverModInitializer = modContainer.getCustomExtension(DedicatedServerModInitializer.class);
                serverModInitializer.ifPresent(DedicatedServerModInitializer::onInitializeServer);
            }
            if (FMLLoader.getDist().isClient()) {
                Optional clientModInitializer = modContainer.getCustomExtension(ClientModInitializer.class);
                clientModInitializer.ifPresent(ClientModInitializer::onInitializeClient);
            }
        }));
    }
}

