package carpet.script.utils;

import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;

import java.util.Map;

import static java.util.Map.entry;

public class Colors
{
    public static final Map<SoundType, String> soundName = Map.ofEntries(
            entry(SoundType.WOOD,   "wood"  ),
            entry(SoundType.GRAVEL, "gravel"),
            entry(SoundType.GRASS,  "grass" ),
            entry(SoundType.LILY_PAD, "lily_pad"),
            entry(SoundType.STONE,  "stone" ),
            entry(SoundType.METAL,  "metal" ),
            entry(SoundType.GLASS , "glass" ),
            entry(SoundType.WOOL  , "wool"  ),
            entry(SoundType.SAND  , "sand"  ),
            entry(SoundType.SNOW  , "snow"  ),
            entry(SoundType.POWDER_SNOW  , "powder_snow"  ),
            entry(SoundType.LADDER, "ladder"),
            entry(SoundType.ANVIL , "anvil" ),
            entry(SoundType.SLIME_BLOCK  , "slime"  ),
            entry(SoundType.HONEY_BLOCK  , "honey"  ),
            entry(SoundType.WET_GRASS , "sea_grass" ),
            entry(SoundType.CORAL_BLOCK , "coral" ),
            entry(SoundType.BAMBOO , "bamboo" ),
            entry(SoundType.BAMBOO_SAPLING , "shoots" ),
            entry(SoundType.SCAFFOLDING , "scaffolding" ),
            entry(SoundType.SWEET_BERRY_BUSH , "berry" ),
            entry(SoundType.CROP , "crop" ),
            entry(SoundType.HARD_CROP , "stem" ),
            entry(SoundType.VINE , "vine" ),
            entry(SoundType.NETHER_WART , "wart" ),
            entry(SoundType.LANTERN , "lantern" ),
            entry(SoundType.STEM, "fungi_stem"),
            entry(SoundType.NYLIUM, "nylium"),
            entry(SoundType.FUNGUS, "fungus"),
            entry(SoundType.ROOTS, "roots"),
            entry(SoundType.SHROOMLIGHT, "shroomlight"),
            entry(SoundType.WEEPING_VINES, "weeping_vine"),
            entry(SoundType.TWISTING_VINES, "twisting_vine"),
            entry(SoundType.SOUL_SAND, "soul_sand"),
            entry(SoundType.SOUL_SOIL, "soul_soil"),
            entry(SoundType.BASALT, "basalt"),
            entry(SoundType.WART_BLOCK, "wart"),
            entry(SoundType.NETHERRACK, "netherrack"),
            entry(SoundType.NETHER_BRICKS, "nether_bricks"),
            entry(SoundType.NETHER_SPROUTS, "nether_sprouts"),
            entry(SoundType.NETHER_ORE, "nether_ore"),
            entry(SoundType.BONE_BLOCK, "bone"),
            entry(SoundType.NETHERITE_BLOCK, "netherite"),
            entry(SoundType.ANCIENT_DEBRIS, "ancient_debris"),
            entry(SoundType.LODESTONE, "lodestone"),
            entry(SoundType.CHAIN, "chain"),
            entry(SoundType.NETHER_GOLD_ORE, "nether_gold_ore"),
            entry(SoundType.GILDED_BLACKSTONE, "gilded_blackstone"),
            entry(SoundType.CANDLE, "candle"),
            entry(SoundType.AMETHYST, "amethyst"),
            entry(SoundType.AMETHYST_CLUSTER, "amethyst_cluster"),
            entry(SoundType.SMALL_AMETHYST_BUD, "small_amethyst_bud"),
            entry(SoundType.MEDIUM_AMETHYST_BUD, "medium_amethyst_bud"),
            entry(SoundType.LARGE_AMETHYST_BUD, "large_amethyst_bud"),

            entry(SoundType.TUFF, "tuff"),
            entry(SoundType.CALCITE, "calcite"),
            entry(SoundType.DRIPSTONE_BLOCK, "dripstone"),
            entry(SoundType.POINTED_DRIPSTONE, "pointed_dripstone"),
            entry(SoundType.COPPER, "copper"),
            entry(SoundType.CAVE_VINES, "cave_vine"),
            entry(SoundType.SPORE_BLOSSOM, "spore_blossom"),
            entry(SoundType.AZALEA, "azalea"),
            entry(SoundType.FLOWERING_AZALEA, "flowering_azalea"),
            entry(SoundType.MOSS_CARPET, "moss_carpet"),
            entry(SoundType.MOSS, "moss"),
            entry(SoundType.BIG_DRIPLEAF, "big_dripleaf"),
            entry(SoundType.SMALL_DRIPLEAF, "small_dripleaf"),
            entry(SoundType.ROOTED_DIRT, "rooted_dirt"),
            entry(SoundType.HANGING_ROOTS, "hanging_roots"),
            entry(SoundType.AZALEA_LEAVES, "azalea_leaves"),
            entry(SoundType.SCULK_SENSOR, "sculk_sensor"),
            entry(SoundType.GLOW_LICHEN, "glow_lichen"),
            entry(SoundType.DEEPSLATE, "deepslate"),
            entry(SoundType.DEEPSLATE_BRICKS, "deepslate_bricks"),
            entry(SoundType.DEEPSLATE_TILES, "deepslate_tiles"),
            entry(SoundType.POLISHED_DEEPSLATE, "polished_deepslate")
    );

    public static final Map<MapColor, String> mapColourName = Map.ofEntries(
            entry(MapColor.NONE     , "air"       ),
            entry(MapColor.GRASS     , "grass"     ),
            entry(MapColor.SAND       , "sand"      ),
            entry(MapColor.WOOL        , "wool"      ),
            entry(MapColor.FIRE       , "tnt"       ),
            entry(MapColor.ICE        , "ice"       ),
            entry(MapColor.METAL      , "iron"      ),
            entry(MapColor.PLANT    , "foliage"   ),
            entry(MapColor.SNOW     , "snow"      ),
            entry(MapColor.CLAY       , "clay"      ),
            entry(MapColor.DIRT       , "dirt"      ),
            entry(MapColor.STONE      , "stone"     ),
            entry(MapColor.WATER      , "water"     ),
            entry(MapColor.WOOD       , "wood"      ),
            entry(MapColor.QUARTZ     , "quartz"    ),
            entry(MapColor.COLOR_ORANGE    , "adobe"     ),
            entry(MapColor.COLOR_MAGENTA   , "magenta"   ),
            entry(MapColor.COLOR_LIGHT_BLUE, "light_blue"),
            entry(MapColor.COLOR_YELLOW    , "yellow"    ),
            entry(MapColor.COLOR_LIGHT_GREEN      , "lime"      ),
            entry(MapColor.COLOR_PINK      , "pink"      ),
            entry(MapColor.COLOR_GRAY      , "gray"      ),
            entry(MapColor.COLOR_LIGHT_GRAY, "light_gray"),
            entry(MapColor.COLOR_CYAN      , "cyan"      ),
            entry(MapColor.COLOR_PURPLE    , "purple"    ),
            entry(MapColor.COLOR_BLUE      , "blue"      ),
            entry(MapColor.COLOR_BROWN     , "brown"     ),
            entry(MapColor.COLOR_GREEN     , "green"     ),
            entry(MapColor.COLOR_RED       , "red"       ),
            entry(MapColor.COLOR_BLACK     , "black"     ),
            entry(MapColor.GOLD      , "gold"      ),
            entry(MapColor.DIAMOND    , "diamond"   ),
            entry(MapColor.LAPIS      , "lapis"     ),
            entry(MapColor.EMERALD    , "emerald"   ),
            entry(MapColor.PODZOL     , "obsidian"  ),
            entry(MapColor.NETHER     , "netherrack"), //TODO fix these
            entry(MapColor.TERRACOTTA_WHITE      , "white_terracotta"      ),
            entry(MapColor.TERRACOTTA_ORANGE    , "orange_terracotta"     ),
            entry(MapColor.TERRACOTTA_MAGENTA   , "magenta_terracotta"    ),
            entry(MapColor.TERRACOTTA_LIGHT_BLUE, "light_blue_terracotta" ),
            entry(MapColor.TERRACOTTA_YELLOW    , "yellow_terracotta"     ),
            entry(MapColor.TERRACOTTA_LIGHT_GREEN      , "lime_terracotta"       ),
            entry(MapColor.TERRACOTTA_PINK      , "pink_terracotta"       ),
            entry(MapColor.TERRACOTTA_GRAY      , "gray_terracotta"       ),
            entry(MapColor.TERRACOTTA_LIGHT_GRAY, "light_gray_terracotta" ),
            entry(MapColor.TERRACOTTA_CYAN      , "cyan_terracotta"       ),
            entry(MapColor.TERRACOTTA_PURPLE    , "purple_terracotta"     ),
            entry(MapColor.TERRACOTTA_BLUE      , "blue_terracotta"       ),
            entry(MapColor.TERRACOTTA_BROWN     , "brown_terracotta"      ),
            entry(MapColor.TERRACOTTA_GREEN     , "green_terracotta"      ),
            entry(MapColor.TERRACOTTA_RED       , "red_terracotta"        ),
            entry(MapColor.TERRACOTTA_BLACK     , "black_terracotta"      ),
            entry(MapColor.CRIMSON_NYLIUM        , "crimson_nylium"        ),
            entry(MapColor.CRIMSON_STEM         , "crimson_stem"          ),
            entry(MapColor.CRIMSON_HYPHAE        , "crimson_hyphae"        ),
            entry(MapColor.WARPED_NYLIUM         , "warped_nylium"         ),
            entry(MapColor.WARPED_STEM           , "warped_stem"           ),
            entry(MapColor.WARPED_HYPHAE         , "warped_hyphae"         ),
            entry(MapColor.WARPED_WART_BLOCK           , "warped_wart"           ),
            entry(MapColor.DEEPSLATE           , "deepslate"           ),
            entry(MapColor.RAW_IRON           , "raw_iron"           ),
            entry(MapColor.GLOW_LICHEN           , "glow_lichen"           )
    );
}
