/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocapcomp.emotecraft.actions;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocapcomp.emotecraft.MocapEmotecraftCompMod;
import org.jetbrains.annotations.Nullable;

public class PlayEmoteAction
implements MocapAction {
    private final UUID uuid;
    @Nullable
    private final Animation animation;

    public PlayEmoteAction(Animation animation) {
        this.uuid = animation.uuid();
        this.animation = animation;
    }

    public PlayEmoteAction(MocapAction.Reader reader, MocapRecordingData data) {
        this.uuid = reader.readUUID();
        this.animation = reader.isDummy() ? null : UniversalEmoteSerializer.getEmote((UUID)this.uuid);
    }

    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addUUID(this.uuid);
    }

    public MocapAction.Result execute(MocapActionContext ctx) {
        Entity entity = ctx.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MocapEmotecraftCompMod.playEmote(ctx.getLevel().getServer(), player, this.animation);
            return MocapAction.Result.OK;
        }
        return MocapAction.Result.IGNORED;
    }
}

