/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.ui;

import com.mojang.realmsclient.RealmsMainScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.BackgroundBuilder;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.core.ui.AgreementPopupScreen;
import org.nokarin.nekoui.core.ui.button.ImageButton;
import org.nokarin.nekoui.core.ui.button.TextIconButton;
import org.nokarin.nekoui.core.ui.layout.ColumnLayout;
import org.nokarin.nekoui.core.ui.layout.UIAnchor;
import org.nokarin.nekoui.core.ui.widget.AnimatedWidget;
import org.nokarin.nekoui.core.ui.widget.VersionInfoWidget;

public class TitleScreen
extends Screen {
    private long startTime = -1L;
    private boolean cleanMode = false;
    private final List<AnimatedWidget> animatedWidgets = new ArrayList<AnimatedWidget>();
    ResourceLocation VERSION_INFO_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/version_info.png");
    ResourceLocation SINGLEPLAYER_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/sword_icon.png");
    ResourceLocation MULTIPLAYER_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/signal_icon.png");
    ResourceLocation OPTIONS_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/settings_icon.png");
    ResourceLocation REALMS_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/realms_icon.png");
    ResourceLocation EXIT_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/exit_icon.png");
    ResourceLocation MODS_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/cube_icon.png");
    ResourceLocation CLEAN_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/clean_icon.png");

    public TitleScreen() {
        super((Component)Component.literal((String)"Title Screen"));
    }

    protected void init() {
        Minecraft client = Minecraft.getInstance();
        Minecraft.getInstance().getWindow().setTitle("NekoUI " + Constants.MCVersion);
        if (!Config.hasAgreed()) {
            client.setScreen((Screen)new AgreementPopupScreen(this));
            return;
        }
        int cleanModeSize = 16;
        int cleanX = UIAnchor.BOTTOM_RIGHT.resolveX(this.width, cleanModeSize);
        int cleanY = UIAnchor.BOTTOM_RIGHT.resolveY(this.height, cleanModeSize);
        AnimatedWidget cleanModeButton = new AnimatedWidget((AbstractWidget)new ImageButton(cleanX, cleanY, cleanModeSize, cleanModeSize, this.CLEAN_ICON_TEXTURE, button -> this.toggleCleanMode(), (Component)Component.translatable((String)"nekoui.menu.clean_mode")), AnimatedWidget.Direction.RIGHT);
        this.addRenderableWidget((GuiEventListener)cleanModeButton);
        if (this.cleanMode) {
            return;
        }
        ColumnLayout menuLayout = new ColumnLayout(UIAnchor.CENTER_LEFT, 4);
        menuLayout.add(new VersionInfoWidget(0, 0, 120, 50, this.VERSION_INFO_TEXTURE, 0.8f));
        menuLayout.add((AbstractWidget)new TextIconButton(0, 0, 120, 45, (Component)Component.translatable((String)"nekoui.menu.play"), button -> client.setScreen((Screen)new SelectWorldScreen((Screen)this)), TextIconButton.TextAlign.LEFT, this.SINGLEPLAYER_ICON_TEXTURE, 1.8f, 35));
        menuLayout.add((AbstractWidget)new TextIconButton(0, 0, 120, 20, (Component)Component.translatable((String)"nekoui.menu.multiplayer"), button -> client.setScreen((Screen)new JoinMultiplayerScreen((Screen)this)), TextIconButton.TextAlign.LEFT, this.MULTIPLAYER_ICON_TEXTURE, 1.0f, 12));
        menuLayout.add((AbstractWidget)new TextIconButton(0, 0, 120, 20, (Component)Component.translatable((String)"nekoui.menu.options"), button -> client.setScreen((Screen)new OptionsScreen((Screen)this, client.options)), TextIconButton.TextAlign.LEFT, this.OPTIONS_ICON_TEXTURE, 1.0f, 12));
        menuLayout.add((AbstractWidget)new TextIconButton(0, 0, 120, 20, (Component)Component.translatable((String)"nekoui.menu.realms"), button -> client.setScreen((Screen)new RealmsMainScreen((Screen)this)), TextIconButton.TextAlign.LEFT, this.REALMS_ICON_TEXTURE, 1.0f, 12));
        menuLayout.add((AbstractWidget)new TextIconButton(0, 0, 120, 20, (Component)Component.translatable((String)"nekoui.menu.mods"), button -> {
            if (Constants.MOD_SCREEN_SUPPLIER != null) {
                client.setScreen(Constants.MOD_SCREEN_SUPPLIER.getModListScreen(this));
            }
        }, TextIconButton.TextAlign.LEFT, this.MODS_ICON_TEXTURE, 1.0f, 12));
        for (AbstractWidget widget : menuLayout.build(this.width, this.height)) {
            AnimatedWidget animated = new AnimatedWidget(widget, AnimatedWidget.Direction.LEFT);
            this.addRenderableWidget((GuiEventListener)animated);
            this.animatedWidgets.add(animated);
        }
        int size = 16;
        int quitX = UIAnchor.TOP_RIGHT.resolveX(this.width, size);
        int quitY = UIAnchor.TOP_RIGHT.resolveY(this.height, size);
        AnimatedWidget quitButton = new AnimatedWidget((AbstractWidget)new ImageButton(quitX, quitY, size, size, this.EXIT_ICON_TEXTURE, button -> client.stop(), (Component)Component.translatable((String)"nekoui.menu.close")), AnimatedWidget.Direction.RIGHT);
        this.addRenderableWidget((GuiEventListener)quitButton);
        this.animatedWidgets.add(quitButton);
        if (this.minecraft != null && this.minecraft.level != null && !this.minecraft.getDebugOverlay().showDebugScreen()) {
            this.minecraft.getDebugOverlay().toggleOverlay();
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        BackgroundBuilder.renderBackground(graphics, this.width, this.height);
        int gradientWidth = this.width / 3;
        int height = this.height;
        for (int x = 0; x < gradientWidth; ++x) {
            float progress = (float)x / (float)gradientWidth;
            int alpha = (int)((1.0f - progress) * 200.0f);
            int color = alpha << 24;
            graphics.fill(x, 0, x + 1, height, color);
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Minecraft client = Minecraft.getInstance();
        this.renderBackground(graphics, mouseX, mouseY, delta);
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        long elapsed = System.currentTimeMillis() - this.startTime;
        int versionFadeAlpha = Math.min(255, (int)(elapsed / 4L));
        int mcVersionX = UIAnchor.BOTTOM_LEFT.resolveX(this.width, 10);
        int mcVersionY = UIAnchor.BOTTOM_LEFT.resolveY(this.height, 10);
        float scale = 0.75f;
        if (!this.cleanMode || versionFadeAlpha > 0) {
            int alpha = this.cleanMode ? versionFadeAlpha : 255;
            int whiteWithAlpha = 0xFFFFFF | alpha << 24;
            graphics.pose().pushPose();
            graphics.pose().scale(scale, scale, 1.0f);
            graphics.drawString(client.font, (String)(this.cleanMode ? "" : "Minecraft " + Constants.MCVersion + " \u00a9 Mojang AB"), (int)((float)mcVersionX / scale), (int)((float)mcVersionY / scale), whiteWithAlpha);
            graphics.pose().popPose();
        }
        super.render(graphics, mouseX, mouseY, delta);
    }

    private void toggleCleanMode() {
        this.cleanMode = !this.cleanMode;
        for (AnimatedWidget widget : this.animatedWidgets) {
            if (this.cleanMode) {
                widget.slideOut();
                continue;
            }
            widget.slideIn();
        }
    }
}

