/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.ui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.ui.button.ImageButton;

public class AnimatedWidget
extends AbstractWidget {
    private final AbstractWidget inner;
    public float opacity = 0.0f;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private boolean animatingOut;
    private boolean animatingIn = true;
    private final Direction direction;

    public AnimatedWidget(AbstractWidget inner, Direction direction) {
        super(inner.getX(), inner.getY(), inner.getWidth(), inner.getHeight(), inner.getMessage());
        this.inner = inner;
        this.direction = direction;
        this.animatingOut = false;
        if (direction == Direction.LEFT) {
            this.offsetX = -30.0f;
        }
        if (direction == Direction.RIGHT) {
            this.offsetX = 30.0f;
        }
        if (direction == Direction.TOP) {
            this.offsetY = -30.0f;
        }
        if (direction == Direction.BOTTOM) {
            this.offsetY = 30.0f;
        }
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        float speed = delta * 0.1f;
        if (this.animatingIn) {
            this.opacity += speed;
            if (this.opacity > 1.0f) {
                this.opacity = 1.0f;
            }
            this.offsetX *= 0.85f;
            this.offsetY *= 0.85f;
            if (Math.abs(this.offsetX) < 0.5f) {
                this.offsetX = 0.0f;
            }
            if (Math.abs(this.offsetY) < 0.5f) {
                this.offsetY = 0.0f;
            }
        }
        if (this.animatingOut) {
            this.opacity -= speed;
            if (this.opacity < 0.0f) {
                this.opacity = 0.0f;
            }
            float slideSpeed = 1.5f;
            if (this.direction == Direction.LEFT) {
                this.offsetX -= slideSpeed;
            }
            if (this.direction == Direction.RIGHT) {
                this.offsetX += slideSpeed;
            }
            if (this.direction == Direction.TOP) {
                this.offsetY -= slideSpeed;
            }
            if (this.direction == Direction.BOTTOM) {
                this.offsetY += slideSpeed;
            }
        }
        if (this.opacity <= 0.0f) {
            return;
        }
        AbstractWidget abstractWidget = this.inner;
        if (abstractWidget instanceof ImageButton) {
            ImageButton imageButton = (ImageButton)abstractWidget;
            imageButton.setExternalOpacity(this.opacity);
        }
        graphics.pose().pushPose();
        graphics.pose().translate(this.offsetX, this.offsetY, 0.0f);
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        this.inner.render(graphics, mouseX, mouseY, delta);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.pose().popPose();
    }

    public void slideOut() {
        this.animatingOut = true;
        this.animatingIn = false;
        this.inner.active = false;
    }

    public void slideIn() {
        this.animatingIn = true;
        this.animatingOut = false;
        if (this.direction == Direction.LEFT) {
            this.offsetX = -30.0f;
        }
        if (this.direction == Direction.RIGHT) {
            this.offsetX = 30.0f;
        }
        if (this.direction == Direction.TOP) {
            this.offsetY = -30.0f;
        }
        if (this.direction == Direction.BOTTOM) {
            this.offsetY = 30.0f;
        }
        this.opacity = 0.0f;
        this.inner.active = true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.inner.active || this.opacity <= 0.0f) {
            return false;
        }
        return this.inner.mouseClicked(mouseX - (double)this.offsetX, mouseY - (double)this.offsetY, button);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.opacity <= 0.0f) {
            return false;
        }
        return this.inner.isMouseOver(mouseX - (double)this.offsetX, mouseY - (double)this.offsetY);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

