/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_442;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.background.Background;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;
import org.nokarin.nekoui.core.config.Config;

public class BackgroundBuilder
extends class_442 {
    public static String selectedBackground = Config.getInstance().background;
    private static int currentFrame = 0;
    private static final long FRAME_DURATION = 50L;
    private static Background cachedBackground;

    public static void selectBackground(@NotNull String background) {
        selectedBackground = background;
        currentFrame = 0;
        cachedBackground = BackgroundBuilder.loadBackground(background);
    }

    private static Background loadBackground(String name) {
        class_2960[] frames = Background.loadAnimatedFramePaths(name);
        if (frames != null && frames.length > 0) {
            return new Background.AnimatedBackground(name, frames);
        }
        return new Background.DefaultBackground();
    }

    public static Background getBackground() {
        return cachedBackground;
    }

    private static void startFrameTimer() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BackgroundBuilder.updateFrame();
            }
        }, 0L, 50L);
    }

    private static void updateFrame() {
        if (cachedBackground != null && cachedBackground.isAnimated()) {
            currentFrame = (currentFrame + 1) % cachedBackground.getFramePaths().length;
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        BackgroundBuilder.renderBackground(graphics, this.field_22789, this.field_22790);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public static void renderBackground(@NotNull class_332 graphics, int width, int height) {
        if (cachedBackground == null) {
            return;
        }
        class_2960[] frames = cachedBackground.getFramePaths();
        if (frames.length == 0) {
            return;
        }
        class_2960 frameId = frames[currentFrame];
        class_1043 texture = BackgroundCache.getOrLoad(frames[currentFrame]);
        if (texture == null) {
            return;
        }
        class_2960 registeredId = class_310.method_1551().method_1531().method_4617("extension_bg/" + frameId.toString().replace(':', '_'), texture);
        RenderSystem.setShaderTexture((int)0, (class_2960)registeredId);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(class_1921::method_62277, registeredId, 0, 0, 0.0f, 0.0f, width, height, width, height);
    }

    static {
        BackgroundBuilder.selectBackground(selectedBackground);
        BackgroundBuilder.startFrameTimer();
    }
}

