/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background.cache;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.utils.ImageUtils;

public class BackgroundCache {
    private static final Map<class_2960, class_1043> cache = new HashMap<class_2960, class_1043>();
    private static final Set<String> SUPPORTED_EXTENSIONS = Set.of("png", "jpg", "jpeg");

    public static class_1043 getOrLoad(class_2960 location) {
        class_1043 class_10432;
        block10: {
            if (!BackgroundCache.isSupportedFormat(location.method_12832())) {
                Constants.LOG.error("Unsupported image format for background: " + location.method_12832(), new Object[0]);
                return null;
            }
            if (cache.containsKey(location)) {
                return cache.get(location);
            }
            InputStream stream = ((class_3298)class_310.method_1551().method_1478().method_14486(location).orElseThrow()).method_14482();
            try {
                class_1043 texture = new class_1043(ImageUtils.loadNativeImage(stream, location.method_12832()));
                cache.put(location, texture);
                class_10432 = texture;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load background frame: " + String.valueOf(location), new Object[0]);
                    Constants.LOG.printStackTrace((Throwable)e, "Background:", "Please enable verbose mode to view more details.", new Appendable[0]);
                    return null;
                }
            }
            stream.close();
        }
        return class_10432;
    }

    public static void preload(class_2960[] locations) {
        for (class_2960 loc : locations) {
            BackgroundCache.getOrLoad(loc);
        }
    }

    private static boolean isSupportedFormat(String path) {
        String lowerPath = path.toLowerCase();
        for (String ext : SUPPORTED_EXTENSIONS) {
            if (!lowerPath.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static void clear() {
        for (class_1043 tex : cache.values()) {
            tex.close();
        }
        cache.clear();
    }
}

