/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.rpc;

import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.ActivityType;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.User;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import net.minecraft.class_310;
import net.minecraft.class_642;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.impl.DiscordStatus;
import org.nokarin.nekoui.utils.GameUtils;

public class DiscordRpc {
    public IPCClient rpc;
    public RichPresence currentPresence;
    public DiscordStatus STATUS = DiscordStatus.Disconnected;
    public String CURRENT_TITLE = "";
    public User CURRENT_USER;
    private boolean wasInWorld = false;
    private boolean wasMultiplayer = false;
    private String lastServerIP = null;
    private String lastGameState = "";
    private long lastPresenceUpdate = 0L;
    private String lastDimensionKey = null;
    private static final long PRESENCE_UPDATE_COOLDOWN = 1000L;
    private final long startTimestamp = System.currentTimeMillis() / 1000L;

    public void init(IPCListener listener) {
        try {
            this.rpc = new IPCClient(Long.parseLong("1323688954679267489"));
            this.rpc.setListener(listener);
            this.rpc.connect(new DiscordBuild[]{DiscordBuild.ANY});
            this.STATUS = DiscordStatus.Connected;
            Constants.LOG.info(Constants.TRANSLATOR.translate("nekoui.rpc.connect", new Object[0]), new Object[0]);
            this.updatePresence();
        }
        catch (NoDiscordClientException ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("nekoui.rpc.error.client", new Object[0]), new Object[0]);
            this.STATUS = DiscordStatus.Closed;
        }
        catch (Exception e) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("nekoui.rpc.error.connection", new Object[0]), new Object[0]);
            Constants.LOG.printStackTrace((Throwable)e, "RPC:", "Please enable verbose mode to view more details.", new Appendable[0]);
            this.STATUS = DiscordStatus.Closed;
        }
    }

    public void updatePresence() {
        if (this.rpc == null || this.rpc.getStatus() != PipeStatus.CONNECTED) {
            Constants.LOG.warn(Constants.TRANSLATOR.translate("nekoui.rpc.error.update", new Object[0]), new Object[0]);
            return;
        }
        long currentTime = System.currentTimeMillis();
        String currentGameState = this.getCurrentGameState();
        String smallImageKey = this.getSmallImageKey();
        if (currentGameState.equals(this.lastGameState) && currentTime - this.lastPresenceUpdate < 1000L) {
            return;
        }
        String currentActivity = smallImageKey.equals("minecraft") ? GameUtils.getUsername() : smallImageKey;
        String details = "NekoUI v1.0.1-release+mc1.21.3";
        this.currentPresence = new RichPresence.Builder().setState(currentGameState).setDetails(details).setActivityType(ActivityType.Playing).setStartTimestamp(this.startTimestamp).setLargeImage("nekoui", "NekoUI").setSmallImage(smallImageKey.toLowerCase(), currentActivity).build();
        this.rpc.sendRichPresence(this.currentPresence);
        this.CURRENT_TITLE = details;
        this.lastGameState = currentGameState;
        this.lastPresenceUpdate = currentTime;
    }

    private String getCurrentGameState() {
        class_310 mc = GameUtils.getMinecraft();
        if (mc.field_1687 == null) {
            return "In Menu";
        }
        if (mc.method_1496() && mc.method_1576() != null) {
            String worldName = this.getWorldName();
            if (worldName != null && !worldName.isEmpty()) {
                return "Playing in " + worldName;
            }
            return "Playing Singleplayer";
        }
        if (mc.method_1558() != null) {
            class_642 serverData = mc.method_1558();
            return "Playing on " + serverData.field_3761;
        }
        return "Playing Minecraft " + Constants.MCVersion;
    }

    private String getSmallImageKey() {
        String dimensionKey;
        class_310 mc = GameUtils.getMinecraft();
        if (mc.field_1687 == null) {
            return "minecraft";
        }
        return switch (dimensionKey = mc.field_1687.method_27983().method_29177().toString()) {
            case "minecraft:overworld" -> "Overworld";
            case "minecraft:the_nether" -> "Nether";
            case "minecraft:the_end" -> "The-End";
            default -> "minecraft";
        };
    }

    private String getWorldName() {
        try {
            String worldName;
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 != null && mc.method_1496() && mc.method_1576() != null && !(worldName = mc.method_1576().method_27728().method_150()).trim().isEmpty()) {
                return worldName;
            }
        }
        catch (Exception e) {
            Constants.LOG.warn("Failed to get world name: {}", e.getMessage());
        }
        return null;
    }

    public void tick() {
        if (!this.isConnected()) {
            return;
        }
        class_310 mc = GameUtils.getMinecraft();
        boolean isInWorld = mc.field_1687 != null;
        boolean isMultiplayer = mc.method_1558() != null;
        String currentServerIP = isMultiplayer ? mc.method_1558().field_3761 : null;
        String currentDimensionKey = null;
        boolean shouldUpdate = false;
        if (this.wasInWorld != isInWorld) {
            shouldUpdate = true;
            this.wasInWorld = isInWorld;
        }
        if (isMultiplayer && (this.lastServerIP == null || !this.lastServerIP.equals(currentServerIP))) {
            shouldUpdate = true;
            this.lastServerIP = currentServerIP;
        }
        if (!isMultiplayer && this.wasMultiplayer) {
            shouldUpdate = true;
            this.lastServerIP = null;
        }
        if (this.wasMultiplayer != isMultiplayer) {
            this.wasMultiplayer = isMultiplayer;
        }
        if (mc.field_1687 != null) {
            currentDimensionKey = mc.field_1687.method_27983().method_29177().toString();
        }
        if (this.lastDimensionKey == null || !this.lastDimensionKey.equals(currentDimensionKey)) {
            this.lastDimensionKey = currentDimensionKey;
            this.updatePresence();
        }
        if (shouldUpdate) {
            this.updatePresence();
        }
    }

    public void shutDown() {
        if (this.rpc != null) {
            try {
                this.rpc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.STATUS = DiscordStatus.Closed;
        this.CURRENT_TITLE = "";
        this.CURRENT_USER = null;
        this.lastGameState = "";
        Constants.LOG.info(Constants.TRANSLATOR.translate("nekoui.rpc.close", new Object[0]), new Object[0]);
    }

    public boolean isConnected() {
        return this.rpc != null && this.rpc.getStatus() == PipeStatus.CONNECTED;
    }
}

