/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_442;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.Background;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.core.utils.PerformanceDetector;
import org.nokarin.nekoui.utils.GameUtils;

public class BackgroundBuilder
extends class_442 {
    public static String selectedBackground = Config.getInstance().getBackground();
    private static Timer animationTimer;
    private static int currentFrame;
    private static final long FRAME_DURATION;
    private static Background cachedBackground;

    public static void selectBackground(@NotNull String background) {
        selectedBackground = background;
        currentFrame = 0;
        cachedBackground = BackgroundBuilder.loadBackground(background);
    }

    private static Background loadBackground(String name) {
        class_2960[] frames = Background.loadAnimatedFramePaths(name);
        if (frames != null && frames.length > 0) {
            return new Background.AnimatedBackground(name, frames);
        }
        return new Background.DefaultBackground();
    }

    public static Background getBackground() {
        return cachedBackground;
    }

    private static void startFrameTimer() {
        if (animationTimer != null) {
            return;
        }
        animationTimer = new Timer();
        animationTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BackgroundBuilder.updateFrame();
            }
        }, 0L, FRAME_DURATION);
    }

    private static void stopFrameTimer() {
        if (animationTimer != null) {
            animationTimer.cancel();
            animationTimer = null;
        }
    }

    private static void updateFrame() {
        if (!GameUtils.getMinecraft().method_1569()) {
            return;
        }
        if (cachedBackground != null && cachedBackground.isAnimated()) {
            currentFrame = (currentFrame + 1) % cachedBackground.getFramePaths().length;
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (cachedBackground == null || cachedBackground.getFramePaths().length == 0) {
            BackgroundBuilder.selectBackground(selectedBackground);
        }
        BackgroundBuilder.renderBackground(graphics, this.field_22789, this.field_22790);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public static void renderBackground(@NotNull class_332 graphics, int width, int height) {
        if (cachedBackground == null) {
            return;
        }
        class_2960[] frames = cachedBackground.getFramePaths();
        if (frames.length == 0) {
            return;
        }
        int frameIndex = Config.getInstance().isLowQualityMode() ? 0 : currentFrame;
        class_2960 registeredId = BackgroundCache.registerTexture(frames[frameIndex]);
        if (registeredId == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)registeredId);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)registeredId);
        graphics.method_25290(class_1921::method_62277, registeredId, 0, 0, 0.0f, 0.0f, width, height, width, height);
    }

    public void method_25432() {
        super.method_25432();
        BackgroundBuilder.stopFrameTimer();
        BackgroundCache.clear();
    }

    static {
        currentFrame = 0;
        FRAME_DURATION = 1000 / Config.getInstance().getBackgroundFrame();
        if (Config.getInstance().isAutoDetectPerformance() && PerformanceDetector.isLowSpecSystem()) {
            Config.getInstance().setLowQualityMode(true);
            Constants.LOG.info("Low-end system detected. Automatically enabled lowQualityMode (static background only).", new Object[0]);
        }
        BackgroundBuilder.selectBackground(selectedBackground);
        if (!Config.getInstance().isLowQualityMode()) {
            BackgroundBuilder.startFrameTimer();
        }
    }
}

