/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.updater.downloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.minecraft.class_310;
import org.nokarin.nekoui.core.Constants;

public class MavenJarDownloader {
    private static final int MAX_RETRY = 3;
    private static final File CACHE_DIR = new File(class_310.method_1551().field_1697, "nekoui/cache");

    public static void downloadAndLaunch(String jarUrl, String filename, String ... args) {
        try {
            File cachedJar;
            if (!CACHE_DIR.exists()) {
                CACHE_DIR.mkdirs();
            }
            if (!(cachedJar = new File(CACHE_DIR, filename)).exists()) {
                Constants.UPDATE_LOG.info("Downloading: " + filename, new Object[0]);
                boolean success = false;
                for (int i = 1; i <= 3 && !success; ++i) {
                    try {
                        Constants.UPDATE_LOG.info("Attempt " + i + "/3", new Object[0]);
                        HttpURLConnection connection = (HttpURLConnection)new URI(jarUrl).toURL().openConnection();
                        connection.setRequestProperty("User-Agent", "Java-Updater");
                        try (InputStream in = connection.getInputStream();){
                            Files.copy(in, cachedJar.toPath(), new CopyOption[0]);
                            Constants.UPDATE_LOG.info("Download complete: " + cachedJar.getAbsolutePath(), new Object[0]);
                            success = true;
                            continue;
                        }
                    }
                    catch (IOException e) {
                        Constants.UPDATE_LOG.warn("Attempt " + i + " failed: " + e.getMessage(), new Object[0]);
                    }
                }
                if (!cachedJar.exists()) {
                    Constants.UPDATE_LOG.error("Failed to download jar after 3 attempts.", new Object[0]);
                    return;
                }
            } else {
                Constants.UPDATE_LOG.info("Using cached JAR: " + cachedJar.getAbsolutePath(), new Object[0]);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(MavenJarDownloader.buildCommand(cachedJar, args));
            processBuilder.inheritIO();
            processBuilder.start();
        }
        catch (Exception e) {
            Constants.UPDATE_LOG.error("Failed to launch update notifier: " + e.getMessage(), e);
        }
    }

    private static String[] buildCommand(File jarFile, String ... args) {
        String[] base = new String[]{"java", "-jar", jarFile.getAbsolutePath()};
        String[] combined = new String[base.length + args.length];
        System.arraycopy(base, 0, combined, 0, base.length);
        System.arraycopy(args, 0, combined, base.length, args.length);
        return combined;
    }
}

