/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.config.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.Background;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.core.gui.button.ImageButton;
import org.nokarin.nekoui.core.gui.button.TextButton;
import org.nokarin.nekoui.core.gui.slider.ConfigSlider;
import org.nokarin.nekoui.core.gui.widget.AnimatedWidget;

public class ConfigScreen
extends class_437 {
    private static final class_310 client = class_310.method_1551();
    private final class_437 parent;
    private int selectedBackgroundIndex = 0;
    private List<String> animatedBackgrounds;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 10;
    private static final float PREVIEW_WIDTH_RATIO = 0.4f;
    private static final float PREVIEW_HEIGHT_RATIO = 0.4f;
    private static final float CAROUSEL_RADIUS = 400.0f;
    private float currentRotation = 0.0f;
    private float targetRotation = 0.0f;
    private final long startTime;
    private class_342 frameField;
    class_2960 BACK_ICON_TEXTURE = class_2960.method_60655((String)"nekoui", (String)"textures/gui/back_icon.png");
    class_2960 NEXT_ICON_TEXTURE = class_2960.method_60655((String)"nekoui", (String)"textures/gui/next_icon.png");
    class_2960 PREV_ICON_TEXTURE = class_2960.method_60655((String)"nekoui", (String)"textures/gui/prev_icon.png");

    public ConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Background Settings"));
        this.parent = parent;
        this.startTime = System.currentTimeMillis();
    }

    protected void method_25426() {
        this.animatedBackgrounds = this.getAvailableAnimatedBackgrounds();
        if (!this.animatedBackgrounds.contains("default")) {
            this.animatedBackgrounds.addFirst("default");
        }
        int backSize = Math.min(16, this.field_22790 / 20);
        this.method_37063((class_364)new AnimatedWidget((class_339)new ImageButton(10, 10, backSize, backSize, this.BACK_ICON_TEXTURE, button -> client.method_1507(this.parent), (class_2561)class_2561.method_43471((String)"nekoui.config.back")), AnimatedWidget.Direction.LEFT));
        int previewWidth = (int)((float)this.field_22789 * 0.4f);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int navButtonSize = Math.min(16, this.field_22789 / 15);
        this.method_37063((class_364)new AnimatedWidget((class_339)new ImageButton(centerX - previewWidth / 2 - navButtonSize - 20, centerY - navButtonSize / 4, navButtonSize, navButtonSize, this.PREV_ICON_TEXTURE, button -> this.switchBackground(-1), (class_2561)class_2561.method_43471((String)"nekoui.config.prev")), AnimatedWidget.Direction.LEFT));
        this.method_37063((class_364)new AnimatedWidget((class_339)new ImageButton(centerX + previewWidth / 2 + 20, centerY - navButtonSize / 4, navButtonSize, navButtonSize, this.NEXT_ICON_TEXTURE, button -> this.switchBackground(1), (class_2561)class_2561.method_43471((String)"nekoui.config.next")), AnimatedWidget.Direction.RIGHT));
        int qualityButtonWidth = Math.min(200, this.field_22789 - 40);
        this.method_37063((class_364)new TextButton(this.field_22789 / 2 - qualityButtonWidth / 2, this.field_22790 - 20 - 80, qualityButtonWidth, 20, (class_2561)class_2561.method_43471((String)"nekoui.config.low.quality.mode").method_27693(" ").method_10852((class_2561)(Config.getInstance().isLowQualityMode() ? class_2561.method_43471((String)"nekoui.config.low.quality.mode.enable") : class_2561.method_43471((String)"nekoui.config.low.quality.mode.disable"))), button -> {
            Config.getInstance().setLowQualityMode(!Config.getInstance().isLowQualityMode());
            button.method_25355((class_2561)class_2561.method_43471((String)"nekoui.config.low.quality.mode").method_27693(" ").method_10852((class_2561)(Config.getInstance().isLowQualityMode() ? class_2561.method_43471((String)"nekoui.config.low.quality.mode.enable") : class_2561.method_43471((String)"nekoui.config.low.quality.mode.disable"))));
            Config.getInstance().save();
        }, TextButton.TextAlign.CENTER));
        this.method_37063((class_364)new ConfigSlider(this.field_22789 / 2 - 100, this.field_22790 - 40 - 30, 200, 20, 1, 60, Config.getInstance().getBackgroundFrame(), val -> {
            Config.getInstance().setBackgroundFrame((int)val);
            Config.getInstance().save();
        }));
        int buttonWidth = Math.min(200, this.field_22789 - 40);
        this.method_37063((class_364)new TextButton(this.field_22789 / 2 - buttonWidth / 2, this.field_22790 - 20 - 20, buttonWidth, 20, (class_2561)class_2561.method_43471((String)"nekoui.config.background.apply"), button -> {
            String selected = this.animatedBackgrounds.get(this.selectedBackgroundIndex);
            Config.getInstance().setBackground(selected);
            Config.getInstance().save();
            client.method_1507(this.parent);
        }, TextButton.TextAlign.CENTER));
        String currentBg = Config.getInstance().getBackground();
        this.selectedBackgroundIndex = Math.max(0, this.animatedBackgrounds.indexOf(currentBg));
        this.currentRotation = this.targetRotation = (float)this.selectedBackgroundIndex * (360.0f / (float)Math.max(1, this.animatedBackgrounds.size()));
    }

    private void switchBackground(int delta) {
        if (this.animatedBackgrounds.isEmpty()) {
            return;
        }
        this.selectedBackgroundIndex = (this.selectedBackgroundIndex + delta + this.animatedBackgrounds.size()) % this.animatedBackgrounds.size();
        this.targetRotation = (float)this.selectedBackgroundIndex * (360.0f / (float)this.animatedBackgrounds.size());
    }

    private List<String> getAvailableAnimatedBackgrounds() {
        String[] backgrounds;
        ArrayList<String> validBackgrounds = new ArrayList<String>();
        for (String name : backgrounds = Background.getAvailableBackgrounds()) {
            class_2960[] frames = Background.loadAnimatedFramePaths(name);
            if (frames == null || frames.length <= 0) continue;
            validBackgrounds.add(name);
        }
        return validBackgrounds;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        if (!this.animatedBackgrounds.isEmpty()) {
            float angleStep = 360.0f / (float)this.animatedBackgrounds.size();
            for (int i = 0; i < this.animatedBackgrounds.size(); ++i) {
                float angle = (float)Math.toRadians((float)i * angleStep - this.currentRotation);
                float x = (float)centerX + (float)Math.sin(angle) * 400.0f;
                float z = (float)Math.cos(angle) * 400.0f;
                float scale = 0.5f + 0.5f * (z + 400.0f) / 800.0f;
                if (!(z > 0.0f)) continue;
                int previewWidth = (int)((float)this.field_22789 * 0.4f * scale);
                int previewHeight = (int)((float)this.field_22790 * 0.4f * scale);
                int previewX = (int)x - previewWidth / 2;
                int previewY = centerY - previewHeight / 2;
                if (!(mouseX >= (double)previewX) || !(mouseX <= (double)(previewX + previewWidth)) || !(mouseY >= (double)previewY) || !(mouseY <= (double)(previewY + previewHeight))) continue;
                this.selectedBackgroundIndex = i;
                this.targetRotation = (float)i * angleStep;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25393() {
        super.method_25393();
        float rotationDiff = this.targetRotation - this.currentRotation;
        if (Math.abs(rotationDiff) > 0.01f) {
            this.currentRotation += rotationDiff * 0.15f;
        }
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, -587202560, -301989888);
        if (this.animatedBackgrounds.isEmpty()) {
            return;
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        float angleStep = 360.0f / (float)this.animatedBackgrounds.size();
        ArrayList<PreviewItem> previewItems = new ArrayList<PreviewItem>();
        for (int i = 0; i < this.animatedBackgrounds.size(); ++i) {
            float angle = (float)Math.toRadians((float)i * angleStep - this.currentRotation);
            float x = (float)centerX + (float)Math.sin(angle) * 400.0f;
            float z = (float)Math.cos(angle) * 400.0f;
            previewItems.add(new PreviewItem(i, x, z));
        }
        previewItems.sort((a, b) -> Float.compare(a.z, b.z));
        for (PreviewItem item : previewItems) {
            String currentBg;
            class_2960[] frames;
            float scale = 0.5f + 0.5f * (item.z + 400.0f) / 800.0f;
            float previewScaleFactor = 0.6f;
            int previewWidth = (int)((float)this.field_22789 * 0.4f * scale * previewScaleFactor);
            int previewHeight = (int)((float)this.field_22790 * 0.4f * scale * previewScaleFactor);
            int previewX = (int)item.x - previewWidth / 2;
            int previewY = centerY - previewHeight / 2 - 60;
            if (!(item.z > 0.0f) || (frames = Background.loadAnimatedFramePaths(currentBg = this.animatedBackgrounds.get(item.index))) == null || frames.length <= 0) continue;
            float alpha = (item.z + 400.0f) / 800.0f;
            if (item.index == this.selectedBackgroundIndex) {
                float time = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
                int borderColor = 0xFF000000 | (int)(Math.sin(time * 2.0f) * 32.0 + 223.0) << 16 | (int)(Math.sin(time * 2.0f + 2.0f) * 32.0 + 223.0) << 8 | (int)(Math.sin(time * 2.0f + 4.0f) * 32.0 + 223.0);
                graphics.method_25294(previewX - 2, previewY - 2, previewX + previewWidth + 2, previewY + previewHeight + 2, borderColor);
            } else {
                graphics.method_25294(previewX - 2, previewY - 2, previewX + previewWidth + 2, previewY + previewHeight + 2, -14540254);
            }
            graphics.method_25294(previewX, previewY, previewX + previewWidth, previewY + previewHeight, -13882324);
            class_2960 registeredId = BackgroundCache.registerTexture(frames[0]);
            if (registeredId == null) {
                return;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderSystem.setShaderTexture((int)0, (class_2960)registeredId);
            graphics.method_25290(class_1921::method_62277, registeredId, previewX, previewY, 0.0f, 0.0f, previewWidth, previewHeight, previewWidth, previewHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (item.index != this.selectedBackgroundIndex) continue;
            int nameWidth = this.field_22793.method_1727(currentBg.toUpperCase());
            graphics.method_25303(this.field_22793, currentBg.toUpperCase(), previewX + (previewWidth - nameWidth) / 2, previewY + previewHeight + 10, 0xFFFFFF);
        }
        String title = Constants.TRANSLATOR.translate("nekoui.config.title", new Object[0]);
        int titleWidth = this.field_22793.method_1727(title);
        graphics.method_25303(this.field_22793, title, (this.field_22789 - titleWidth) / 2, 20, 0xFFFFFF);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private record PreviewItem(int index, float x, float z) {
    }
}

