/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.background.Background;
import org.nokarin.nekoui.core.background.BackgroundBuilder;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.core.ui.button.TextButton;
import org.nokarin.nekoui.core.ui.layout.ColumnLayout;
import org.nokarin.nekoui.core.ui.layout.UIAnchor;
import org.nokarin.nekoui.core.ui.widget.AnimatedWidget;

public class AgreementPopupScreen
extends Screen {
    private final Screen parent;
    private static Background cachedBackground;

    public AgreementPopupScreen(Screen parent) {
        super((Component)Component.literal((String)"User Agreement"));
        this.parent = parent;
    }

    protected void init() {
        Minecraft client = Minecraft.getInstance();
        ColumnLayout layout = new ColumnLayout(UIAnchor.CENTER, 10);
        layout.add((AbstractWidget)new TextButton(0, 0, 180, 20, (Component)Component.literal((String)"I Agree"), btn -> {
            Config.setAgreed();
            client.setScreen(this.parent);
        }, TextButton.TextAlign.CENTER));
        for (AbstractWidget widget : layout.build(this.width, this.height)) {
            this.addRenderableWidget((GuiEventListener)new AnimatedWidget(widget, AnimatedWidget.Direction.BOTTOM));
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation[] frames = BackgroundBuilder.getBackground().getFramePaths();
        if (frames.length == 0) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)frames[0]);
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        graphics.blit(RenderType::guiTextured, frames[0], 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        graphics.fillGradient(0, 0, this.width, this.height, -1442840576, -1442840576);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        int centerX = this.width / 2;
        int startY = this.height / 2 - 90;
        graphics.drawCenteredString(this.font, "Welcome to NekoUI", centerX, startY, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Before using this mod, please agree to the following terms:", centerX, startY + 15, 0xCCCCCC);
        graphics.drawCenteredString(this.font, "https://github.strivo.xyz/nekoui-download/blob/main/LICENSE", centerX, startY + 30, 0x55AAFF);
        graphics.drawCenteredString(this.font, "By clicking 'I Agree', you accept responsibility for its usage.", centerX, startY + 50, 0xAAAAAA);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int centerX = this.width / 2;
        int urlY = this.height / 2 - 90 + 30;
        String url = "https://github.strivo.xyz/nekoui-download/blob/main/LICENSE";
        int textWidth = this.font.width(url);
        int x1 = centerX - textWidth / 2;
        int x2 = centerX + textWidth / 2;
        if (mouseY >= (double)urlY && mouseY <= (double)(urlY + 10) && mouseX >= (double)x1 && mouseX <= (double)x2) {
            Minecraft.getInstance().keyboardHandler.setClipboard(url);
            Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(open -> {
                if (open) {
                    Util.getPlatform().openUri(url);
                }
                Minecraft.getInstance().setScreen((Screen)this);
            }, url, false));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

