/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.ui.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TextButton
extends Button {
    private final TextAlign alignment;

    public TextButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, TextAlign align) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.alignment = align;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int textColor;
        Font font = Minecraft.getInstance().font;
        int n = textColor = this.active ? 0xFFFFFF : 0xA0A0A0;
        if (this.isHoveredOrFocused()) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, Integer.MIN_VALUE);
        }
        int maxTextWidth = this.getWidth() - 8;
        String rawText = this.getMessage().getString();
        Object trimmedText = font.plainSubstrByWidth(rawText, maxTextWidth);
        int textWidth = font.width((String)trimmedText);
        int textX = switch (this.alignment.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getX() + 4;
            case 2 -> this.getX() + this.getWidth() - textWidth - 4;
            case 1 -> this.getX() + (this.getWidth() - textWidth) / 2;
        };
        int textY = this.getY() + (this.getHeight() - 8) / 2;
        if (!((String)trimmedText).equals(rawText) && ((String)trimmedText).length() > 3) {
            trimmedText = ((String)trimmedText).substring(0, ((String)trimmedText).length() - 3) + "...";
        }
        graphics.drawString(font, (String)trimmedText, textX, textY, textColor);
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

