/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.updater;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    @Override
    public int compare(String v1, String v2) {
        String[] v2Parts;
        v1 = this.normalizeVersion(v1);
        v2 = this.normalizeVersion(v2);
        String[] v1Parts = v1.split("-");
        int coreCompare = this.compareVersionNumbers(v1Parts[0], (v2Parts = v2.split("-"))[0]);
        if (coreCompare != 0) {
            return coreCompare;
        }
        String suffix1 = v1Parts.length > 1 ? v1Parts[1] : "";
        String suffix2 = v2Parts.length > 1 ? v2Parts[1] : "";
        return this.compareSuffixes(suffix1, suffix2);
    }

    private String normalizeVersion(String version) {
        int plusIndex;
        if ((version = version.trim().toLowerCase()).startsWith("v")) {
            version = version.substring(1);
        }
        if ((plusIndex = version.indexOf(43)) != -1) {
            version = version.substring(0, plusIndex);
        }
        return version;
    }

    private int compareVersionNumbers(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? this.parseIntSafe(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? this.parseIntSafe(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }

    private int compareSuffixes(String s1, String s2) {
        int rank1 = this.getSuffixRank(s1);
        int rank2 = this.getSuffixRank(s2);
        return Integer.compare(rank1, rank2);
    }

    private int getSuffixRank(String suffix) {
        return switch (suffix) {
            case "alpha" -> 1;
            case "beta" -> 2;
            case "rc", "release-candidate" -> 3;
            case "release" -> 4;
            case "" -> 5;
            default -> 6;
        };
    }

    private int parseIntSafe(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

