/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.world.entity.player.Player;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.core.rpc.DiscordRpc;
import org.nokarin.nekoui.core.rpc.intergrations.IPCListeners;
import org.nokarin.nekoui.updater.ModVersionChecker;
import org.nokarin.nekoui.utils.GameUtils;
import org.nokarin.nekoui.utils.ModUtils;
import org.nokarin.nekoui.utils.OSUtils;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public final class NekoUI {
    private static boolean initialized = false;
    private static Runnable initCallback;
    public static final DiscordRpc DISCORD_RPC;
    public static boolean isDataLoaded;
    public static Minecraft instance;
    public static User session;
    public static Player player;
    public static String username;
    public static String uuid;
    public static final ModVersionChecker UPDATER;

    public NekoUI(Runnable callback) {
        initCallback = callback;
        this.scheduleTick();
    }

    public NekoUI() {
        this(null);
    }

    public static void init() {
        UPDATER.checkForUpdates(() -> Constants.LOG.info("NekoUI > Update check completed.", new Object[0]));
        if (Constants.isDebugging()) {
            Constants.LOG.setDebugMode(true);
        }
        Constants.LOG.debugWarn("NekoUI > You are running in a debugging environment, some features may not function properly!", new Object[0]);
        Constants.LOG.debugInfo("NekoUI > Detected OS: %1$s (Architecture: %2$s, Is 64-Bit: %3$s)", OSUtils.OS_NAME, OSUtils.OS_ARCH, OSUtils.IS_64_BIT);
        if (initCallback != null) {
            initCallback.run();
        }
        isDataLoaded = true;
        DISCORD_RPC.init(new IPCListeners());
        Config.getInstance();
        initialized = true;
    }

    private void scheduleTick() {
        Constants.scheduleTickEvent("NekoUI", this::clientTick);
    }

    private void clientTick() {
        if (!Constants.IS_GAME_CLOSING) {
            instance = ModUtils.getMinecraft();
            if (initialized || instance != null) {
                session = GameUtils.getSession(instance);
                if (initialized) {
                    player = GameUtils.getPlayer();
                    username = GameUtils.getUsername();
                    uuid = GameUtils.getUuid();
                    DISCORD_RPC.tick();
                } else if (session != null) {
                    NekoUI.init();
                }
            }
        }
    }

    static {
        DISCORD_RPC = new DiscordRpc();
        isDataLoaded = false;
        UPDATER = new ModVersionChecker("nekoui", "https://raw.githubusercontent.com/SITCommunity/NekoUI-Download/main/update.json", "v1.0.1", "release", "1.21.4");
    }
}

