/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.background.Background;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;
import org.nokarin.nekoui.core.config.Config;

public class BackgroundBuilder
extends TitleScreen {
    public static String selectedBackground = Config.getInstance().background;
    private static int currentFrame = 0;
    private static final long FRAME_DURATION = 50L;
    private static Background cachedBackground;

    public static void selectBackground(@NotNull String background) {
        selectedBackground = background;
        currentFrame = 0;
        cachedBackground = BackgroundBuilder.loadBackground(background);
    }

    private static Background loadBackground(String name) {
        ResourceLocation[] frames = Background.loadAnimatedFramePaths(name);
        if (frames != null && frames.length > 0) {
            return new Background.AnimatedBackground(name, frames);
        }
        return new Background.DefaultBackground();
    }

    public static Background getBackground() {
        return cachedBackground;
    }

    private static void startFrameTimer() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BackgroundBuilder.updateFrame();
            }
        }, 0L, 50L);
    }

    private static void updateFrame() {
        if (cachedBackground != null && cachedBackground.isAnimated()) {
            currentFrame = (currentFrame + 1) % cachedBackground.getFramePaths().length;
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        BackgroundBuilder.renderBackground(graphics, this.width, this.height);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public static void renderBackground(@NotNull GuiGraphics graphics, int width, int height) {
        if (cachedBackground == null) {
            return;
        }
        ResourceLocation[] frames = cachedBackground.getFramePaths();
        if (frames.length == 0) {
            return;
        }
        ResourceLocation registeredId = BackgroundCache.registerTexture(frames[currentFrame]);
        if (registeredId == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)registeredId);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(RenderType::guiTextured, registeredId, 0, 0, 0.0f, 0.0f, width, height, width, height);
    }

    static {
        BackgroundBuilder.selectBackground(selectedBackground);
        BackgroundBuilder.startFrameTimer();
    }
}

