/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.ui.layout;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import org.nokarin.nekoui.core.ui.layout.UIAnchor;

public class RowLayout {
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private final int spacing;
    private final UIAnchor anchor;

    public RowLayout(UIAnchor anchor, int spacing) {
        this.anchor = anchor;
        this.spacing = spacing;
    }

    public void add(AbstractWidget widget) {
        this.widgets.add(widget);
    }

    public List<AbstractWidget> build(int screenWidth, int screenHeight) {
        int totalWidth = this.widgets.stream().mapToInt(w -> w.getWidth()).sum() + this.spacing * (this.widgets.size() - 1);
        int baseX = this.anchor.resolveX(screenWidth, totalWidth);
        int baseY = this.anchor.resolveY(screenHeight, this.widgets.get(0).getHeight());
        int x = baseX;
        for (AbstractWidget widget : this.widgets) {
            widget.setX(x);
            widget.setY(baseY);
            x += widget.getWidth() + this.spacing;
        }
        return this.widgets;
    }
}

