/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;

public class Background {
    private final String name;
    private final class_2960[] framePaths;

    protected Background(String name, class_2960[] framePaths) {
        this.name = name;
        this.framePaths = framePaths;
    }

    public String getName() {
        return this.name;
    }

    public class_2960[] getFramePaths() {
        return this.framePaths;
    }

    public boolean isAnimated() {
        return this.framePaths.length > 1;
    }

    public static class_2960[] createFramePaths(String basePath, int frameCount) {
        class_2960[] paths = new class_2960[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            String path = basePath + (i + 1) + ".png";
            paths[i] = class_2960.method_60655((String)"nekoui", (String)path);
        }
        return paths;
    }

    public static String[] getAvailableBackgrounds() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        HashSet backgrounds = new HashSet();
        resourceManager.method_14488("background", location -> {
            String path = location.method_12832().toLowerCase();
            return path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg");
        }).forEach((location, resource) -> {
            String path = location.method_12832();
            String[] parts = path.split("/");
            if (parts.length >= 2) {
                String bgName = parts[1].toLowerCase();
                backgrounds.add(bgName);
            }
        });
        return backgrounds.toArray(new String[0]);
    }

    public static class_2960[] loadAnimatedFramePaths(String backgroundName) {
        if (backgroundName == null || backgroundName.isEmpty()) {
            Constants.LOG.warn("Background name is null or empty. Falling back to default background.", new Object[0]);
            return new DefaultBackground().getFramePaths();
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        ArrayList<class_2960> frameList = new ArrayList<class_2960>();
        String folder = "background/" + backgroundName.toLowerCase();
        resourceManager.method_14488(folder, location -> {
            String path = location.method_12832().toLowerCase();
            return path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg");
        }).forEach((location, resource) -> {
            if (location.method_12832().startsWith(folder)) {
                frameList.add((class_2960)location);
            }
        });
        if (frameList.isEmpty()) {
            Constants.LOG.warn("No frames found in '{}'. Falling back to default background.", folder);
            return new DefaultBackground().getFramePaths();
        }
        frameList.sort(Comparator.comparingInt(location -> {
            String filename = location.method_12832().substring(location.method_12832().lastIndexOf(47) + 1);
            String digits = filename.replaceAll("\\D+", "");
            try {
                return Integer.parseInt(digits);
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }));
        ArrayList<class_2960> validFrames = new ArrayList<class_2960>();
        for (class_2960 loc : frameList) {
            String filename = loc.method_12832().substring(loc.method_12832().lastIndexOf(47) + 1);
            if (!filename.matches(".*\\d+.*")) continue;
            validFrames.add(loc);
        }
        if (validFrames.isEmpty()) {
            Constants.LOG.warn("No numbered frames found in '{}'. Ignoring non-numeric files. Using default background.", folder);
            return new DefaultBackground().getFramePaths();
        }
        return frameList.toArray(new class_2960[0]);
    }

    public static class DefaultBackground
    extends Background {
        public DefaultBackground() {
            super("DEFAULT", DefaultBackground.createFramePaths("background/default/default", 1));
        }
    }

    public static class AnimatedBackground
    extends Background {
        public AnimatedBackground(String name, class_2960[] framePaths) {
            super(name, framePaths);
            BackgroundCache.preload(framePaths);
        }
    }
}

