/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background.cache;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.utils.ImageUtils;

public class BackgroundCache {
    private static final Map<class_2960, class_1043> textureCache = new HashMap<class_2960, class_1043>();
    private static final Set<String> SUPPORTED_EXTENSIONS = Set.of("png", "jpg", "jpeg");
    private static final ExecutorService preloadExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("BackgroundPreloader");
        return t;
    });

    public static class_2960 registerTexture(class_2960 originalLocation) {
        class_2960 class_29602;
        block12: {
            if (!BackgroundCache.isSupportedFormat(originalLocation.method_12832())) {
                Constants.LOG.error("Unsupported image format: " + String.valueOf(originalLocation), new Object[0]);
                return null;
            }
            if (textureCache.containsKey(originalLocation)) {
                return BackgroundCache.buildRegisteredId(originalLocation);
            }
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> BackgroundCache.registerTexture(originalLocation));
                return BackgroundCache.buildRegisteredId(originalLocation);
            }
            Optional optional = class_310.method_1551().method_1478().method_14486(originalLocation);
            if (optional.isEmpty()) {
                return null;
            }
            InputStream stream = ((class_3298)optional.get()).method_14482();
            try {
                class_1043 texture = new class_1043(ImageUtils.loadNativeImage(stream, originalLocation.method_12832()));
                class_2960 registeredId = BackgroundCache.buildRegisteredId(originalLocation);
                class_310.method_1551().method_1531().method_4616(registeredId, (class_1044)texture);
                textureCache.put(originalLocation, texture);
                class_29602 = registeredId;
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load texture: " + String.valueOf(originalLocation), new Object[0]);
                    Constants.LOG.printStackTrace((Throwable)e, "Background: ", "Verbose Info", new Appendable[0]);
                    return null;
                }
            }
            stream.close();
        }
        return class_29602;
    }

    public static void preload(class_2960[] locations) {
        for (class_2960 loc : locations) {
            preloadExecutor.submit(() -> BackgroundCache.registerTexture(loc));
        }
    }

    private static boolean isSupportedFormat(String path) {
        String lower = path.toLowerCase();
        return SUPPORTED_EXTENSIONS.stream().anyMatch(lower::endsWith);
    }

    private static class_2960 buildRegisteredId(class_2960 original) {
        return class_2960.method_60655((String)"nekoui", (String)("extension_bg/" + original.method_12836() + "_" + original.method_12832().replace('/', '_')));
    }

    public static void clear() {
        for (class_1043 tex : textureCache.values()) {
            tex.close();
        }
        textureCache.clear();
    }

    public static void shutdownPreloader() {
        preloadExecutor.shutdown();
    }
}

