/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.class_310;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.updater.VersionComparator;
import org.nokarin.nekoui.utils.FileUtils;
import org.nokarin.nekoui.utils.StringUtils;
import org.nokarin.nekoui.utils.UrlUtils;

public class ModVersionChecker {
    private final String modID;
    private final String updateUrl;
    private final String currentGameVersion;
    private String targetLatestVersion;
    private String targetRecommendedVersion;
    private final String normalizedCurrentVersion;
    public static UpdateState currentState = UpdateState.PENDING;
    public static String targetVersion;
    public String downloadUrl;

    public ModVersionChecker(String modID, String updateUrl, String currentVersion, String versionLabel, String currentGameVersion) {
        this.modID = modID;
        this.updateUrl = updateUrl;
        this.currentGameVersion = currentGameVersion;
        String currentVersionRaw = currentVersion + "-" + versionLabel + "+mc" + currentGameVersion;
        this.normalizedCurrentVersion = this.normalizeVersion(currentVersionRaw);
    }

    private String normalizeVersion(String version) {
        int dashIndex;
        int plusIndex = version.indexOf(43);
        if (plusIndex != -1) {
            version = version.substring(0, plusIndex);
        }
        if ((dashIndex = version.indexOf(45)) != -1) {
            version = version.substring(0, dashIndex);
        }
        return version;
    }

    public void flushData() {
        currentState = UpdateState.PENDING;
        this.targetRecommendedVersion = "";
        this.targetLatestVersion = "";
        targetVersion = "";
        this.downloadUrl = "";
    }

    public void checkForUpdates(Runnable callback) {
        Constants.getThreadFactory().newThread(() -> this.process(callback)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Runnable callback) {
        try {
            boolean hasLatest;
            this.flushData();
            if (StringUtils.isNullOrEmpty(this.updateUrl)) {
                return;
            }
            Constants.LOG.info("Starting version check for \"%s\" (MC %s) at \"%s\"", this.modID, this.currentGameVersion, this.updateUrl);
            String data = UrlUtils.getURLText(this.updateUrl, "UTF-8");
            Constants.LOG.debugInfo("Received update data:\n%s", data);
            Map json = FileUtils.getJsonData(data, Map.class, new FileUtils.Modifiers[0]);
            Map promos = (Map)json.get("promos");
            this.downloadUrl = (String)json.get("homepage");
            this.targetRecommendedVersion = (String)promos.get(this.currentGameVersion + "-recommended");
            this.targetLatestVersion = (String)promos.get(this.currentGameVersion + "-latest");
            VersionComparator comparator = new VersionComparator();
            boolean hasRecommended = !StringUtils.isNullOrEmpty(this.targetRecommendedVersion);
            boolean bl = hasLatest = !StringUtils.isNullOrEmpty(this.targetLatestVersion);
            if (hasRecommended) {
                this.handleUpdateState(comparator, this.targetRecommendedVersion, this.targetLatestVersion, hasLatest);
            } else if (hasLatest) {
                this.handleBetaState(comparator, this.targetLatestVersion);
            } else {
                currentState = UpdateState.BETA;
            }
            this.logUpdateStatus();
            if (currentState == UpdateState.OUTDATED || currentState == UpdateState.BETA_OUTDATED) {
                ModVersionChecker.launchUpdateNotifier(targetVersion);
            }
        }
        catch (Throwable ex) {
            Constants.LOG.error("Failed to check for updates", ex);
            currentState = UpdateState.FAILED;
        }
        finally {
            if (callback != null) {
                callback.run();
            }
        }
    }

    private void handleUpdateState(VersionComparator comparator, String targetRecommendedVersion, String targetLatestVersion, boolean hasLatest) {
        int diff = comparator.compare(targetRecommendedVersion, this.normalizedCurrentVersion);
        if (diff == 0) {
            currentState = UpdateState.UP_TO_DATE;
        } else if (diff < 0) {
            currentState = UpdateState.AHEAD;
            if (hasLatest && comparator.compare(this.normalizedCurrentVersion, targetLatestVersion) < 0) {
                currentState = UpdateState.OUTDATED;
                targetVersion = targetLatestVersion;
            }
        } else {
            currentState = UpdateState.OUTDATED;
            targetVersion = targetRecommendedVersion;
        }
    }

    private void handleBetaState(VersionComparator comparator, String targetLatestVersion) {
        currentState = comparator.compare(this.normalizedCurrentVersion, targetLatestVersion) < 0 ? UpdateState.BETA_OUTDATED : UpdateState.BETA;
        targetVersion = targetLatestVersion;
    }

    private void logUpdateStatus() {
        if (currentState == UpdateState.OUTDATED) {
            Constants.LOG.warn("Current version: \"%s\" is \"%s\" | Latest version: \"%s\"", this.normalizedCurrentVersion, currentState.getDisplayName(), targetVersion);
        } else {
            Constants.LOG.info("Current version: \"%s\" is \"%s\"", this.normalizedCurrentVersion, currentState.getDisplayName());
        }
    }

    public static void launchUpdateNotifier(String version) {
        try {
            InputStream in = ModVersionChecker.class.getResourceAsStream("/assets/nekoui/update-notifier.jar");
            if (in == null) {
                Constants.LOG.error("update-notifier.jar not found in resources.", new Object[0]);
                return;
            }
            File modsPath = class_310.method_1551().field_1697;
            File tempJar = File.createTempFile("update-notifier", ".jar");
            tempJar.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempJar);){
                in.transferTo(out);
            }
            new ProcessBuilder("java", "-jar", tempJar.getAbsolutePath(), version, Constants.GAME_LOADER, Constants.MCVersion, String.valueOf(modsPath) + "/mods").inheritIO().start();
        }
        catch (IOException e) {
            Constants.LOG.printStackTrace((Throwable)e, "Update Notifier: ", "Failed to launch update notifier.", new Appendable[0]);
        }
    }

    public static enum UpdateState {
        FAILED,
        UP_TO_DATE("Latest"),
        AHEAD,
        OUTDATED,
        BETA_OUTDATED("Beta (Outdated)"),
        BETA,
        PENDING;

        private final String displayName;

        private UpdateState() {
            this.displayName = StringUtils.formatWord(this.name().toLowerCase());
        }

        private UpdateState(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

